import request from '@/utils/request'

const prefix = '/data/excel'

/**
 * 上传excel
 * @param data
 * @returns {*}
 */
export function uploadExcel(data) {
    return request({
        url: `${prefix}/upload`,
        method: 'post',
        data,
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    })
}

/**
 * 下载模板
 * @param excelId
 * @returns {*}
 */
export function downloadTemplate(excelId) {
    return request({
        url: `${prefix}/download/template`,
        method: 'get',
        params:{excelId},
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        responseType: "blob",
    })
}

/**
 * 下载模板
 * @param excelId
 * @returns {*}
 */
export function getTemplateFileName(excelId) {
    return request({
        url: `${prefix}/download/template/filename`,
        method: 'get',
        params:{excelId}
    })
}

export async function blobValidate(data) {
    try {
        const text = await data.text();
        JSON.parse(text);
        return false;
    } catch (error) {
        return true;
    }
}

/**
 * 获取机构数据
 * @param name
 * @param year
 * @param type
 * @returns {*}
 */
export function queryArea(name,year,type = '0') {
    return request({
        url: `${prefix}/queryArea`,
        method: 'get',
        params:{name,year,type}
    })
}

/**
 * 更新机构数据
 * @param data
 * @returns {*}
 */
export function updateArea(data){
    return request({
        url: `${prefix}/updateArea`,
        method: 'post',
        data
    })
}

/**
 * 导出修改后的excel
 * @param name
 * @param year
 * @returns {*}
 */
export function exportExcel(name,year) {
    return request({
        url: `${prefix}/export`,
        method: 'get',
        params:{name,year},
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        responseType: "blob",
    })
}
