import request from '@/utils/request'

// 查询项目规则列表
export function listItemConfict(query) {
  return request({
    url: '/basis/itemConfict/list',
    method: 'get',
    params: query
  })
}

// 查询项目规则详细
export function getItemConfict(id) {
  return request({
    url: '/basis/itemConfict/' + id,
    method: 'get'
  })
}

// 新增项目规则
export function addItemConfict(data) {
  return request({
    url: '/basis/itemConfict',
    method: 'post',
    data: data
  })
}

// 修改项目规则
export function updateItemConfict(data) {
  return request({
    url: '/basis/itemConfict',
    method: 'put',
    data: data
  })
}

// 删除项目规则
export function delItemConfict(id) {
  return request({
    url: '/basis/itemConfict/' + id,
    method: 'delete'
  })
}

// 导出项目规则
export function exportItemConfict(query) {
  return request({
    url: '/basis/itemConfict/export',
    method: 'get',
    params: query
  })
}