import request from '@/utils/request'

const prefix = '/data/import'

/**
 * 查询数据源字典
 * @returns {AxiosPromise<any>}
 */
export function queryDatasource() {
    return request({
        url: `${prefix}/datasource`,
        method: 'get'
    })
}

/**
 * 查询表信息
 * @param dataSourceId
 * @returns {AxiosPromise<any>}
 */
export function queryTable(dataSourceId) {
    return request({
        url: `${prefix}/datasource/table`,
        method: 'get',
        params:{dataSourceId}
    })
}

/**
 * 查询数据库字段字典
 * @param dataSourceId
 * @param tableName
 * @returns {AxiosPromise}
 */
export function queryDbField(dataSourceId,tableName) {
    return request({
        url: `${prefix}/datasource/field`,
        method: 'get',
        params:{dataSourceId,tableName}
    })
}

/**
 * 创建物理表
 * @param tableName
 * @param templateId
 * @returns {*}
 */
export function createTable(tableName,templateId){
    return request({
        url: `${prefix}/table/create`,
        method: 'get',
        params:{tableName,templateId}
    })
}

/**
 * 数据分析并导出
 * @param templateId
 * @returns {*}
 */
export function analyzeExport(templateId){
    return request({
        url: `${prefix}/analyze/export`,
        method: 'get',
        params:{templateId},
        responseType: "blob",
    })
}

/**
 * 清空数据
 * @param data
 * @returns {*}
 */
export function clearTemp(data){
    return request({
        url: `${prefix}/clearTemp`,
        method: 'post',
        data
    })
}

/**
 * 一键导入正式库
 * @param data
 * @returns {*}
 */
export function syncDb(data){
    return request({
        url: `${prefix}/syncDb`,
        method: 'post',
        data
    })
}

