import request from '@/utils/request'

const prefix = '/data/template'

/**
 * 模板查询
 * @param params
 * @returns {*}
 */
export function queryTemplate(params) {
    return request({
        url: `${prefix}`,
        method: 'get',
        params
    })
}

/**
 * 新增模板
 * @param data
 * @returns {*}
 */
export function addTemplate(data) {
    return request({
        url: `${prefix}`,
        method: 'post',
        data
    })
}

/**
 * 修改模板
 * @param data
 * @returns {*}
 */
export function updateTemplate(data) {
    return request({
        url: `${prefix}/update`,
        method: 'post',
        data
    })
}

/**
 * 删除模板
 * @param templateId
 * @returns {*}
 */
export function deleteTemplate(templateId) {
    return request({
        url: `${prefix}/delete`,
        method: 'get',
        params:{templateId}
    })
}

/**
 * 查询模板的所有字段数据
 * @param templateId
 * @returns {*}
 */
export function getAllTemplateField(templateId) {
    return request({
        url: `${prefix}/allField`,
        method: 'get',
        params:{templateId}
    })
}

/**
 * 查询模板异常字段
 * @param templateId
 * @returns {*}
 */
export function getTemplateErrorField(templateId) {
    return request({
        url: `${prefix}/fieldError`,
        method: 'get',
        params: {templateId}
    })
}

/**
 * 同步异常字段
 */
export function syncTemplateErrorField(data) {
    return request({
        url: `${prefix}/syncFieldError`,
        method: 'post',
        data
    })
}

/**
 * 查询模板的所有规则数据
 * @param templateId
 * @returns {*}
 */
export function getAllTemplateRule(templateId) {
    return request({
        url: `${prefix}/allRule`,
        method: 'get',
        params:{templateId}
    })
}


/**
 * 新增规则
 * @param data
 * @returns {*}
 */
export function addRuleByTemplate(data) {
    return request({
        url: `${prefix}/rule`,
        method: 'post',
        data
    })
}

/**
 * 修改规则
 * @param data
 * @returns {*}
 */
export function updateRuleByTemplate(data) {
    return request({
        url: `${prefix}/rule/update`,
        method: 'post',
        data
    })
}

/**
 * 删除规则
 * @param ruleId
 * @param templateId
 * @returns {*}
 */
export function deleteRuleByTemplate(ruleId,templateId) {
    return request({
        url: `${prefix}/rule/delete`,
        method: 'get',
        params:{ruleId,templateId}
    })
}

/**
 * 查询此类型模板的其它年份列表
 * @param data
 * @returns {*}
 */
export function queryOtherYears(data) {
    return request({
        url: `${prefix}/otherYears`,
        method: 'post',
        data
    })
}
