import Vue from 'vue'
import Router from 'vue-router'
/* Layout */
import Layout from '@/layout'
import EmptyLayout from '@/layout/EmptyLayout/Index'

Vue.use(Router)

/**
 * Note: 路由配置项
 *
 * hidden: true                     // 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
 * alwaysShow: true                 // 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
 *                                  // 只有一个时，会将那个子路由当做根路由显示在侧边栏--如引导页面
 *                                  // 若你想不管路由下面的 children 声明的个数都显示你的根路由
 *                                  // 你可以设置 alwaysShow: true，这样它就会忽略之前定义的规则，一直显示根路由
 * redirect: noRedirect             // 当设置 noRedirect 的时候该路由在面包屑导航中不可被点击
 * name:'router-name'               // 设定路由的名字，一定要填写不然使用<keep-alive>时会出现各种问题
 * query: '{"id": 1, "name": "ry"}' // 访问路由的默认传递参数
 * roles: ['admin', 'common']       // 访问路由的角色权限
 * permissions: ['a:a:a', 'b:b:b']  // 访问路由的菜单权限
 * meta : {
    noCache: true                   // 如果设置为true，则不会被 <keep-alive> 缓存(默认 false)
    title: 'title'                  // 设置该路由在侧边栏和面包屑中展示的名字
    icon: 'svg-name'                // 设置该路由的图标，对应路径src/assets/icons/svg
    breadcrumb: false               // 如果设置为false，则不会在breadcrumb面包屑中显示
    activeMenu: '/system/user'      // 当路由设置了该属性，则会高亮相对应的侧边栏。
  }
 */

// 公共路由
export const constantRoutes = [
    {
        path: '/',
        component: EmptyLayout,
        hidden: true,
        redirect: '/emport',
        children: [
            {
                path: 'emport',
                component: () => import('@/views/emport/emport/index'),
                name: 'Emport',
                meta: { title: '数据导入', icon: '' }
            },
            {
                path: 'rule',
                component: () => import('@/views/emport/rule/index'),
                name: 'Rule',
                meta: { title: '规则管理', icon: '' }
            },
            {
                path: 'dataSource',
                component: () => import('@/views/emport/datasource/index'),
                name: 'DatsSource',
                meta: { title: '数据源管理', icon: '' }
            },
            {
                path: 'field',
                component: () => import('@/views/emport/field/index'),
                name: 'Field',
                meta: { title: '字段管理', icon: '' }
            },
            {
                path: 'area',
                component: () => import('@/views/emport/area/index'),
                name: 'Area',
                meta: { title: '区域管理', icon: '' }
            },
        ]
    },
    {
        path: '/redirect',
        component: Layout,
        hidden: true,
        children: [
            {
                path: '/redirect/:path(.*)',
                component: () => import('@/views/redirect')
            }
        ]
    },
    {
        path: '/login',
        component: () => import('@/views/login'),
        hidden: true
    },
    {
        path: '/open',
        component: EmptyLayout,
        hidden: true,
        children: [
            {
                path: 'manualReservation',
                component: () => import('@/views/open/manualReservation/index'),
                name: 'ManualReservation',
                meta: { title: '手动预约', icon: '' }
            }
        ]
    },
    {
        path: '/OpenRedirect',
        component: () => import('@/views/OpenRedirect'),
        hidden: true
    },
    {
        path: '/addNumTable',
        component: Layout,
        hidden: true,
        children: [
            {
                path: '/',
                component: () => import('@/views/resource/addNumTable/index'),
                name: '新增号表',
                meta: { title: '新增号表', icon: '' }
            }
        ]
    },
    {
        path: '/customerAppointment',
        component: Layout,
        hidden: true,
        children: [
            {
                path: '/',
                component: () => import('@/views/resource/apply/customerAppointment'),
                name: 'CustomerAppointment',
                meta: { title: '手动预约', icon: '' }
            }
        ]
    },
    /*{
      path: '/manualReservation',
      component: Layout,
      hidden: true,
      children: [
        {
          path: '/',
          component: () => import('@/views/resource/apply/manualReservation'),
          name: '手动预约',
          meta: { title: '手动预约', icon: '' }
        }
      ]
    },*/
    {
        path: '/404',
        component: () => import('@/views/error/404'),
        hidden: true
    },
    {
        path: '/401',
        component: () => import('@/views/error/401'),
        hidden: true
    },
    {
        path: '',
        component: Layout,
        redirect: 'index',
        children: [
            {
                path: 'index',
                component: () => import('@/views/index'),
                name: 'Index',
                meta: { title: '首页', icon: 'dashboard', affix: true }
            }
        ]
    },
    {
        path: '/user',
        component: Layout,
        hidden: true,
        redirect: 'noredirect',
        children: [
            {
                path: 'profile',
                component: () => import('@/views/system/user/profile/index'),
                name: '个人中心',
                meta: { title: '个人中心', icon: 'user' }
            }
        ]
    },
    {
        path: '/dict',
        component: Layout,
        hidden: true,
        children: [
            {
                path: 'type/data/:dictId(\\d+)',
                component: () => import('@/views/system/dict/data'),
                name: '字典数据',
                meta: { title: '字典数据', icon: '' }
            }
        ]
    },
    {
        path: '/userView',
        component: () => import('@/views/information/userView/index'),
        hidden: true
    },
    {
        path: '/tabuser',
        component: Layout,
        hidden: true,
        children: [
            {
                path: ':userinfo',
                component: () => import('@/views/information/user/index'),
                name: '用户信息',
                meta: { title: '用户信息', icon: '' }
            }
        ]
    },
    {
        path: '/views',
        component: Layout,
        hidden: true,
        children: [
            {
                path: ':menuinfo',
                component: () => import('@/views/information/view/index'),
                name: '视图信息',
                meta: { title: '视图信息', icon: '' }
            }
        ]
    },
    {
        path: '/gen',
        component: Layout,
        hidden: true,
        children: [
            {
                path: 'edit/:tableId(\\d+)',
                component: (resolve) => require(['@/views/tool/gen/editTable'], resolve),
                name: 'GenEdit',
                meta: { title: '修改生成配置' }
            }
        ]
    }
]

// 动态路由，基于用户权限动态去加载
export const dynamicRoutes = []
export default new Router({
    mode: 'history', // 去掉url中的#
    scrollBehavior: () => ({ y: 0 }),
    routes: constantRoutes
})
