package com.wechat.common.utils;

import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils extends org.apache.commons.lang3.time.DateUtils {
   public static String YYYY = "yyyy";
   public static String YYYY_MM = "yyyy-MM";
   public static String YYYY_MM_DD = "yyyy-MM-dd";
   public static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
   public static String YYYYMMDDHHMMSSSSS = "yyyyMMddhhmmssSSS";
   public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
   private static String[] parsePatterns = new String[]{
      "yyyy-MM-dd",
      "yyyy-MM-dd HH:mm:ss",
      "yyyy-MM-dd HH:mm",
      "yyyy-MM",
      "yyyy/MM/dd",
      "yyyy/MM/dd HH:mm:ss",
      "yyyy/MM/dd HH:mm",
      "yyyy/MM",
      "yyyy.MM.dd",
      "yyyy.MM.dd HH:mm:ss",
      "yyyy.MM.dd HH:mm",
      "yyyy.MM"
   };

   public static Date getNowDate() {
      return new Date();
   }

   public static String getDate() {
      return dateTimeNow(YYYY_MM_DD);
   }

   public static final String getTime() {
      return dateTimeNow(YYYY_MM_DD_HH_MM_SS);
   }

   public static final String dateTimeNow() {
      return dateTimeNow(YYYYMMDDHHMMSS);
   }

   public static final String dateTimeNowFull() {
      return dateTimeNow(YYYYMMDDHHMMSSSSS);
   }

   public static final String dateTimeNow(final String format) {
      return parseDateToStr(format, new Date());
   }

   public static final String dateTime(final Date date) {
      return parseDateToStr(YYYY_MM_DD, date);
   }

   public static final String parseDateToStr(final String format, final Date date) {
      return new SimpleDateFormat(format).format(date);
   }

   public static final Date dateTime(final String format, final String ts) {
      try {
         return new SimpleDateFormat(format).parse(ts);
      } catch (ParseException var3) {
         throw new RuntimeException(var3);
      }
   }

   public static final String datePath() {
      Date now = new Date();
      return DateFormatUtils.format(now, "yyyy/MM/dd");
   }

   public static final String dateTime() {
      Date now = new Date();
      return DateFormatUtils.format(now, "yyyyMMdd");
   }

   public static Date parseDate(Object str) {
      if (str == null) {
         return null;
      } else {
         try {
            return parseDate(str.toString(), parsePatterns);
         } catch (ParseException var2) {
            return null;
         }
      }
   }

   public static Date getServerStartDate() {
      long time = ManagementFactory.getRuntimeMXBean().getStartTime();
      return new Date(time);
   }

   public static String getDatePoor(Date endDate, Date nowDate) {
      long nd = 86400000L;
      long nh = 3600000L;
      long nm = 60000L;
      long diff = endDate.getTime() - nowDate.getTime();
      long day = diff / nd;
      long hour = diff % nd / nh;
      long min = diff % nd % nh / nm;
      return day + "天" + hour + "小时" + min + "分钟";
   }

   public static String getDateStr(Date date) {
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
      return sdf.format(date);
   }

   public static String DateToStr(Date date) {
      SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
      String dataFormat = sdf.format(date);
      System.out.println(dataFormat);
      return dataFormat;
   }

   public static String getTimeStr(Date date) {
      SimpleDateFormat sdf1 = new SimpleDateFormat("HH:mm:ss");
      return sdf1.format(date);
   }

   public static long getTimeLong(String timeStr) {
      String[] my = timeStr.split(":");
      int hour = Integer.parseInt(my[0]);
      int min = Integer.parseInt(my[1]);
      int sec = 0;
      if (my.length == 3) {
         sec = Integer.parseInt(my[2]);
      }

      return (long)(hour * 3600 + min * 60 + sec);
   }

   public static boolean nowTimeIsInRange(String beginTimeStr, String endTimeStr) {
      long beginTime = getTimeLong(beginTimeStr);
      long endTime = getTimeLong(endTimeStr);
      long nowTime = getTimeLong(getTimeStr(new Date()));
      return nowTime >= beginTime && nowTime <= endTime;
   }

   public static boolean nowDateIsInRange(String dateStr, String beginTimeStr, String endTimeStr) {
      long endTime = parseDate(dateStr + " " + endTimeStr).getTime();
      long nowTime = new Date().getTime();
      return nowTime <= endTime;
   }

   public static List<String> findDates(String dBegin, String dEnd) throws ParseException {
      DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
      Calendar calBegin = Calendar.getInstance();
      calBegin.setTime(format.parse(dBegin));
      Calendar calEnd = Calendar.getInstance();
      calEnd.setTime(format.parse(dEnd));
      List<String> Datelist = new ArrayList<>();
      Datelist.add(format.format(calBegin.getTime()));

      while (format.parse(dEnd).after(calBegin.getTime())) {
         calBegin.add(5, 1);
         Datelist.add(format.format(calBegin.getTime()));
      }

      return Datelist;
   }
}
