package com.wechat.common.utils.sql;

import com.wechat.common.utils.StringUtils;

public class SqlUtil {
   public static String SQL_PATTERN = "[a-zA-Z0-9_\\ \\,]+";

   public static String escapeOrderBySql(String value) {
      return StringUtils.isNotEmpty(value) && !isValidOrderBySql(value) ? "" : value;
   }

   public static boolean isValidOrderBySql(String value) {
      return value.matches(SQL_PATTERN);
   }
}
