package com.wechat.common.webserviceClient;

import com.alibaba.fastjson.JSONObject;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebServiceClient {
   protected final Logger logger = LoggerFactory.getLogger(WebServiceClient.class);

   public static String subWebService(String json) throws Exception {
      String requestXml = JSONObject.toJSON(json).toString();
      System.out.println("调用发布数据集服务:" + requestXml);

      try {
         String endpoint = "http://10.0.10.18:8080/datacenter/rpc/webservice/SubscriptionService?wsdl";
         String webServiceNameSpace = "http://server.webservice.rpc.win.org/";
         String webServiceMethod = "saveDataSetJson";
         Service service = new Service();
         Call call = (Call)service.createCall();
         call.setTargetEndpointAddress(endpoint);
         call.setOperationName(new QName(webServiceNameSpace, webServiceMethod));
         call.addParameter("a", XMLType.XSD_STRING, ParameterMode.IN);
         call.setReturnType(XMLType.XSD_STRING);
         String responseXml = (String)call.invoke(new Object[]{requestXml});
         System.out.println(responseXml);
         return responseXml;
      } catch (ServiceException var8) {
         var8.printStackTrace();
         throw new ServiceException("调用发布数据集服务异常", var8);
      }
   }

   public static void main(String[] args) {
      String json = "{\"parameters\":{\"sourcetype\":\"I\",\"sourceid\":\"YJYY\"},\"D02023\":[{\"DE06.00.151.08\":\"3358230_06301002D\",\"DE01.00.008.00\":\"3358230\",\"DE02.01.039.65\":\"普国银\",\"DE06.00.151.01\":\"2020-11-23 00:00:00\",\"DE06.00.048.02\":\"2020-11-23 00:00:00\",\"DE06.00.048.05\":\"16:30-17:00\",\"DE08.10.055.04\":\"2020-11-23 16:30:00\",\"DE08.10.055.05\":\"2020-11-23 17:00:00\",\"DE06.00.151.07\":\"A00504\",\"DE06.00.151.04\":\"1\",\"DE06.00.151.06\":\"001212\",\"DE04.30.020.00\":\"心脏彩超+心功能测定+室壁运动分析(TVI)\",\"DE04.30.020.04\":\"心血管超声队列\",\"DE01.00.051.53\":\"A\",\"DE01.00.018.12\":\"门诊2楼\",\"DE08.10.025.20\":\"0313\",\"DE88.00.001.00\":\"1.请在预约时段开始前5-20分钟到超声检查室登记。（早于20分钟无法登记）\\n2.预约当日有效，当日过后检查需重新预约。\",\"DE06.00.048.06\":\"20\"}]}";

      try {
         new WebServiceClient();
         subWebService(json);
      } catch (Exception var3) {
         var3.printStackTrace();
      }
   }
}
