package com.wechat.common.webserviceClient;

import com.alibaba.fastjson.JSONObject;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XhWebServiceClient {
   protected final Logger logger = LoggerFactory.getLogger(XhWebServiceClient.class);

   public static String SubWebService(String map) throws Exception {
      String requestXml = JSONObject.toJSON(map).toString();
      System.out.println("调用esb发布数据集服务:" + requestXml);
      String responseXml = "";

      try {
         String endpoint = "http://10.0.10.18:8080/datacenter/rpc/webservice/SubscriptionService?wsdl";
         String webServiceNameSpace = "http://webservice.rpc.win.org/";
         String webServiceMethod = "saveDataSetJson";
         Service service = new Service();
         Call call = (Call)service.createCall();
         call.setTargetEndpointAddress(endpoint);
         call.setOperationName(new QName(webServiceNameSpace, webServiceMethod));
         call.addParameter("arg0", XMLType.XSD_STRING, ParameterMode.IN);
         call.setReturnType(XMLType.XSD_STRING);
         return (String)call.invoke(new Object[]{requestXml});
      } catch (ServiceException var8) {
         var8.printStackTrace();
         System.out.println("调用发布数据接口异常:" + var8.getMessage());
         throw new ServiceException("请求webservice服务异常", var8);
      }
   }

   public static String SubWebServiceBySSO(String map) throws Exception {
      String requestXml = JSONObject.toJSON(map).toString();
      System.out.println("调用单点登录服务:" + requestXml);
      String responseXml = "";

      try {
         String endpoint = "http://10.0.10.7:8283/SSOWebService.asmx?wsdl";
         String webServiceNameSpace = "http://tempuri.org/";
         String webServiceMethod = "GetSSOToken";
         Service service = new Service();
         Call call = (Call)service.createCall();
         call.setTargetEndpointAddress(endpoint);
         call.setOperationName(new QName(webServiceNameSpace, webServiceMethod));
         call.addParameter("arg0", XMLType.XSD_STRING, ParameterMode.IN);
         call.setReturnType(XMLType.XSD_STRING);
         responseXml = (String)call.invoke(new Object[]{requestXml});
         System.out.println("调用单点登录数据结果：" + responseXml);
         return responseXml;
      } catch (ServiceException var8) {
         var8.printStackTrace();
         System.out.println("调用单点登录数据接口异常:" + var8.getMessage());
         throw new ServiceException("调用单点登录服务异常", var8);
      }
   }

   public static void main(String[] args) {
      String xml = "{\"parameters\":{\"pagerecord\":\"9999\",\"sharedatacode\":\"S00014\",\"pageno\":\"1\",\"ORGCODE\":\"66\",\"Reservationid\":\"P00202007030311380926074\"}}";

      try {
         new XhWebServiceClient();
         SubWebService(xml);
      } catch (Exception var3) {
         var3.printStackTrace();
      }
   }
}
