package com.wechat.framework.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties("wechatlogin.client")
@Component
public class WeChatOAuthConfig {
   private String clientId;
   private String clientSecret;
   private String accessTokenUri;
   private String userInfoUri;

   public String getClientId() {
      return this.clientId;
   }

   public String getClientSecret() {
      return this.clientSecret;
   }

   public String getAccessTokenUri() {
      return this.accessTokenUri;
   }

   public String getUserInfoUri() {
      return this.userInfoUri;
   }

   public void setClientId(final String clientId) {
      this.clientId = clientId;
   }

   public void setClientSecret(final String clientSecret) {
      this.clientSecret = clientSecret;
   }

   public void setAccessTokenUri(final String accessTokenUri) {
      this.accessTokenUri = accessTokenUri;
   }

   public void setUserInfoUri(final String userInfoUri) {
      this.userInfoUri = userInfoUri;
   }

   @Override
   public String toString() {
      return "WeChatOAuthConfig(clientId="
         + this.getClientId()
         + ", clientSecret="
         + this.getClientSecret()
         + ", accessTokenUri="
         + this.getAccessTokenUri()
         + ", userInfoUri="
         + this.getUserInfoUri()
         + ")";
   }

   @Override
   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof WeChatOAuthConfig)) {
         return false;
      } else {
         WeChatOAuthConfig other = (WeChatOAuthConfig)o;
         if (!other.canEqual(this)) {
            return false;
         } else {
            Object this$clientId = this.getClientId();
            Object other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId == null : this$clientId.equals(other$clientId)) {
               Object this$clientSecret = this.getClientSecret();
               Object other$clientSecret = other.getClientSecret();
               if (this$clientSecret == null ? other$clientSecret == null : this$clientSecret.equals(other$clientSecret)) {
                  Object this$accessTokenUri = this.getAccessTokenUri();
                  Object other$accessTokenUri = other.getAccessTokenUri();
                  if (this$accessTokenUri == null ? other$accessTokenUri == null : this$accessTokenUri.equals(other$accessTokenUri)) {
                     Object this$userInfoUri = this.getUserInfoUri();
                     Object other$userInfoUri = other.getUserInfoUri();
                     return this$userInfoUri == null ? other$userInfoUri == null : this$userInfoUri.equals(other$userInfoUri);
                  } else {
                     return false;
                  }
               } else {
                  return false;
               }
            } else {
               return false;
            }
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof WeChatOAuthConfig;
   }

   @Override
   public int hashCode() {
      int PRIME = 59;
      int result = 1;
      Object $clientId = this.getClientId();
      result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
      Object $clientSecret = this.getClientSecret();
      result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
      Object $accessTokenUri = this.getAccessTokenUri();
      result = result * 59 + ($accessTokenUri == null ? 43 : $accessTokenUri.hashCode());
      Object $userInfoUri = this.getUserInfoUri();
      return result * 59 + ($userInfoUri == null ? 43 : $userInfoUri.hashCode());
   }
}
