package com.wechat.framework.manager;

import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ShutdownManager {
   private static final Logger logger = LoggerFactory.getLogger("sys-user");

   @PreDestroy
   public void destroy() {
      this.shutdownAsyncManager();
   }

   private void shutdownAsyncManager() {
      try {
         logger.info("====关闭后台任务任务线程池====");
         AsyncManager.me().shutdown();
      } catch (Exception var2) {
         logger.error(var2.getMessage(), var2);
      }
   }
}
