package com.wechat.project.basis.controller;

import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.basis.domain.Operation;
import com.wechat.project.basis.service.IOperationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/basis/operationDict"})
public class OperationController extends BaseController {
   @Autowired
   private IOperationService operationService;

   @PreAuthorize("@ss.hasPermi('basis:operationDict:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(Operation operation) {
      this.startPage();
      List<Operation> list = this.operationService.selectOperationList(operation);
      return this.getDataTable(list);
   }

   @PreAuthorize("@ss.hasPermi('basis:operationDict:export')")
   @Log(
      title = "手术字典",
      businessType = BusinessType.EXPORT
   )
   @GetMapping({"/export"})
   public AjaxResult export(Operation operation) {
      List<Operation> list = this.operationService.selectOperationList(operation);
      ExcelUtil<Operation> util = new ExcelUtil<>(Operation.class);
      return util.exportExcel(list, "operationDict");
   }

   @PreAuthorize("@ss.hasPermi('basis:operationDict:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable("id") Long id) {
      return AjaxResult.success(this.operationService.selectOperationById(id));
   }

   @PreAuthorize("@ss.hasPermi('basis:operationDict:add')")
   @Log(
      title = "手术字典",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@RequestBody Operation operation) {
      return this.toAjax(this.operationService.insertOperation(operation));
   }

   @PreAuthorize("@ss.hasPermi('basis:operationDict:edit')")
   @Log(
      title = "手术字典",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@RequestBody Operation operation) {
      return this.toAjax(this.operationService.updateOperation(operation));
   }

   @PreAuthorize("@ss.hasPermi('basis:operationDict:remove')")
   @Log(
      title = "手术字典",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.operationService.deleteOperationByIds(ids));
   }
}
