package com.wechat.project.basis.service.impl;

import com.alibaba.fastjson.JSON;
import com.wechat.common.utils.DateUtils;
import com.wechat.project.basis.domain.DataSourceByPT;
import com.wechat.project.basis.domain.Dept;
import com.wechat.project.basis.domain.DeptMainInfo;
import com.wechat.project.basis.domain.Emp;
import com.wechat.project.basis.domain.MainParameters;
import com.wechat.project.basis.domain.Operation;
import com.wechat.project.basis.domain.OperationMainInfo;
import com.wechat.project.basis.domain.PTResponse;
import com.wechat.project.basis.domain.UserMainInfo;
import com.wechat.project.basis.mapper.DeptMapper;
import com.wechat.project.basis.mapper.EmpMapper;
import com.wechat.project.basis.mapper.OperationMapper;
import com.wechat.project.basis.service.IOperationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationServiceImpl implements IOperationService {
   @Autowired
   private OperationMapper operationMapper;
   @Autowired
   private EmpMapper empMapper;
   @Autowired
   private DeptMapper deptMapper;

   @Override
   public String mainService(String request) {
      long start = System.currentTimeMillis();
      System.out.println(request);
      System.out.println("进入接口时间日期：-->" + DateUtils.getTime());
      PTResponse rs = new PTResponse();
      if (!request.isEmpty() && request != null) {
         try {
            new DataSourceByPT();
            DataSourceByPT e = (DataSourceByPT)JSON.parseObject(request, DataSourceByPT.class);
            String datasetcode = e.getMainParameters().getDatasetcode();
            switch (datasetcode) {
               case "D03015":
                  return this.takeOperationInfo(request);
               case "D02002":
                  return this.takeDeptInfo(request);
               case "D02003":
                  return this.takeUserInfo(request);
               default:
                  rs.setErrorNo("0");
                  rs.setErrorMessage("非订阅数据，接口未做处理");
                  return JSON.toJSONString(rs);
            }
         } catch (Exception var9) {
            rs.setErrorNo("0");
            rs.setErrorMessage("系统报错：" + var9.getMessage());
            return JSON.toJSONString(rs);
         }
      } else {
         rs.setErrorNo("-1");
         rs.setErrorMessage("入参为null");
         return JSON.toJSONString(rs);
      }
   }

   public String takeOperationInfo(String request) {
      System.out.println(DateUtils.getTime() + "进入订阅手术字典接口");
      PTResponse rs = new PTResponse();
      OperationMainInfo operationMainInfo = (OperationMainInfo)JSON.parseObject(request, OperationMainInfo.class);
      int n = 0;
      if (operationMainInfo == null) {
         rs.setErrorNo("0");
         rs.setErrorMessage("入参有误！");
      } else {
         MainParameters mainParameters = operationMainInfo.getMainParameters();
         if (!mainParameters.getSourceType().equals("I") && !mainParameters.getSourceType().equals("U")) {
            if (mainParameters.getSourceType().equals("D")) {
               for (Operation item : operationMainInfo.getList()) {
                  n += this.operationMapper.deleteOperationByCode(item.getOpsCode());
               }
            }
         } else {
            for (Operation item : operationMainInfo.getList()) {
               if (this.operationMapper.selectCountOperation(item.getOpsCode()) > 0) {
                  this.operationMapper.deleteOperationByCode(item.getOpsCode());
                  n += this.insertOperation(item);
               } else {
                  n += this.insertOperation(item);
               }
            }
         }
      }

      if (n > 0) {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作成功！");
      } else {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作失败！");
      }

      return JSON.toJSONString(rs);
   }

   public String takeDeptInfo(String request) {
      System.out.println(DateUtils.getTime() + "进入订阅科室接口");
      PTResponse rs = new PTResponse();
      DeptMainInfo deptMainInfo = (DeptMainInfo)JSON.parseObject(request, DeptMainInfo.class);
      int n = 0;
      if (deptMainInfo == null) {
         rs.setErrorNo("0");
         rs.setErrorMessage("入参有误！");
      } else {
         MainParameters mainParameters = deptMainInfo.getMainParameters();
         List<Dept> list = deptMainInfo.getList();
         if (!mainParameters.getSourceType().equals("I") && !mainParameters.getSourceType().equals("U")) {
            if (mainParameters.getSourceType().equals("D")) {
               for (Dept item : list) {
                  n += this.deptMapper.deleteDeptByCode(item.getDeptCode());
               }
            }
         } else {
            for (Dept item : list) {
               if (this.deptMapper.selectCountDept(item.getDeptCode()) > 0) {
                  this.deptMapper.deleteDeptByCode(item.getDeptCode());
                  n += this.deptMapper.insertDept(item);
               } else {
                  n += this.deptMapper.insertDept(item);
               }
            }
         }
      }

      if (n > 0) {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作成功！");
      } else {
         rs.setErrorNo("-1");
         rs.setErrorMessage("操作失败！");
      }

      return JSON.toJSONString(rs);
   }

   public String takeUserInfo(String request) {
      System.out.println(DateUtils.getTime() + "进入订阅人员接口");
      PTResponse rs = new PTResponse();
      UserMainInfo userMainInfo = (UserMainInfo)JSON.parseObject(request, UserMainInfo.class);
      int n = 0;
      if (userMainInfo == null) {
         rs.setErrorNo("-1");
         rs.setErrorMessage("入参有误！");
      } else {
         MainParameters mainParameters = userMainInfo.getMainParameters();
         List<Emp> list = userMainInfo.getList();
         if (!mainParameters.getSourceType().equals("I") && !mainParameters.getSourceType().equals("U")) {
            if (mainParameters.getSourceType().equals("D")) {
               for (Emp item : list) {
                  n += this.empMapper.deleteEmpByCode(item.getEmpCode());
               }
            }
         } else {
            for (Emp item : list) {
               if (this.empMapper.selectEmpCountByCode(item.getEmpCode()) > 0) {
                  this.empMapper.deleteEmpByCode(item.getEmpCode());
                  n += this.empMapper.insertEmp(item);
               } else {
                  n += this.empMapper.insertEmp(item);
               }
            }
         }
      }

      if (n > 0) {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作成功！");
      } else {
         rs.setErrorNo("-1");
         rs.setErrorMessage("操作失败！");
      }

      return JSON.toJSONString(rs);
   }

   @Override
   public Operation selectOperationById(Long id) {
      return this.operationMapper.selectOperationById(id);
   }

   @Override
   public List<Operation> selectOperationList(Operation operation) {
      return this.operationMapper.selectOperationList(operation);
   }

   @Override
   public int insertOperation(Operation operation) {
      return this.operationMapper.insertOperation(operation);
   }

   @Override
   public int updateOperation(Operation operation) {
      return this.operationMapper.updateOperation(operation);
   }

   @Override
   public int deleteOperationByIds(Long[] ids) {
      return this.operationMapper.deleteOperationByIds(ids);
   }

   @Override
   public int deleteOperationById(Long id) {
      return this.operationMapper.deleteOperationById(id);
   }
}
