package com.wechat.project.common;

import com.wechat.common.constant.Constants;
import com.wechat.common.utils.IdUtils;
import com.wechat.common.utils.VerifyCodeUtils;
import com.wechat.common.utils.sign.Base64;
import com.wechat.framework.redis.RedisCache;
import com.wechat.framework.web.domain.AjaxResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaptchaController {
   @Autowired
   private RedisCache redisCache;

   @GetMapping({"/captchaImage"})
   public AjaxResult getCode(HttpServletResponse response) throws IOException {
      String verifyCode = VerifyCodeUtils.generateVerifyCode(4);
      String uuid = IdUtils.simpleUUID();
      String verifyKey = "captcha_codes:" + uuid;
      this.redisCache.setCacheObject(verifyKey, verifyCode, Constants.CAPTCHA_EXPIRATION, TimeUnit.MINUTES);
      int w = 111;
      int h = 36;
      ByteArrayOutputStream stream = new ByteArrayOutputStream();
      VerifyCodeUtils.outputImage(w, h, stream, verifyCode);

      AjaxResult var9;
      try {
         AjaxResult ajax = AjaxResult.success();
         ajax.put("uuid", uuid);
         ajax.put("img", Base64.encode(stream.toByteArray()));
         return ajax;
      } catch (Exception var13) {
         var13.printStackTrace();
         var9 = AjaxResult.error(var13.getMessage());
      } finally {
         stream.close();
      }

      return var9;
   }
}
