package com.wechat.project.menutree.service.impl;

import com.wechat.project.menutree.Utils.MD5Util;
import com.wechat.project.menutree.domain.User;
import com.wechat.project.menutree.mapper.UserMapper;
import com.wechat.project.menutree.service.IUserService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl implements IUserService {
   @Resource
   private UserMapper userMapper;

   @Override
   public User selectLogin(String username, String password) {
      return this.userMapper.selectLogin(username, password);
   }

   @Override
   public List<User> selectUserList(User user) {
      return this.userMapper.selectUserList(user);
   }

   @Override
   public List<User> selectUserAll() {
      return this.userMapper.selectUserAll();
   }

   @Override
   public User selectUserById(Long id) {
      return this.userMapper.selectUserById(id);
   }

   @Override
   public int deleteUserById(Long id) {
      return this.userMapper.deleteUserById(id);
   }

   @Override
   public int deleteUserByIds(Long[] ids) {
      return this.userMapper.deleteUserByIds(ids);
   }

   @Override
   public int insertUser(User user) {
      String pwd = MD5Util.getMD5String(user.getPassword());
      user.setPassword(pwd);
      return this.userMapper.insertUser(user);
   }

   @Override
   public int updateUser(User user) {
      return this.userMapper.updateUser(user);
   }
}
