package com.wechat.project.menutree.service.impl;

import com.wechat.project.menutree.domain.Menu;
import com.wechat.project.menutree.domain.View;
import com.wechat.project.menutree.mapper.TestsMapper;
import com.wechat.project.menutree.mapper.ViewMapper;
import com.wechat.project.menutree.service.IViewService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ViewServiceImpl implements IViewService {
   @Autowired
   private ViewMapper viewMapper;
   @Autowired
   private TestsMapper testsMapper;

   @Override
   public Map<String, Object> findMenu(String userId) {
      Map<String, Object> data = new HashMap<>();
      List<View> menuList = this.viewMapper.getMenuById(userId);
      data.put("menu", menuList);
      return data;
   }

   @Override
   public List<Menu> menufindOne(String name) {
      System.out.println(name);
      return this.testsMapper.menufindOne1(name);
   }

   @Override
   public List<Menu> menuList(Menu menu) {
      return this.testsMapper.menuList(menu);
   }

   @Override
   public List<View> selectViewList(View view) {
      return this.viewMapper.selectViewList(view);
   }

   @Override
   public List<View> selectViewAll() {
      return this.viewMapper.selectViewAll();
   }

   @Override
   public View selectViewById(Long id) {
      return this.viewMapper.selectViewById(id);
   }

   @Override
   public int deleteViewById(Long id) {
      return this.viewMapper.deleteViewById(id);
   }

   @Override
   public int deleteViewByIds(Long[] ids) {
      return this.viewMapper.deleteViewByIds(ids);
   }

   @Override
   public int insertView(View view) {
      return this.viewMapper.insertView(view);
   }

   @Override
   public int updateView(View view) {
      return this.viewMapper.updateView(view);
   }
}
