package com.wechat.project.mobile.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wechat.common.utils.http.HttpUtils;
import com.wechat.framework.config.ALiChatOAuthConfig;
import com.wechat.framework.config.WeChatOAuthConfig;
import com.wechat.framework.redis.RedisCache;
import com.wechat.framework.security.service.SysLoginService;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.project.mobile.domain.UserWechat;
import com.wechat.project.mobile.domain.WechatAuthResult;
import com.wechat.project.mobile.service.impl.UserWechatServiceImpl;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/mapi/user"})
public class MobWxUserController extends BaseController {
   private static final Logger log = LoggerFactory.getLogger(MobWxUserController.class);
   @Autowired
   private SysLoginService loginService;
   @Autowired
   private RedisCache redisCache;
   @Autowired
   private WeChatOAuthConfig weChatOAuthConfig;
   @Autowired
   private UserWechatServiceImpl userWechatService;
   @Autowired
   private ALiChatOAuthConfig aLiChatOAuthConfig;

   @PostMapping({"/auth"})
   public AjaxResult auth(@RequestParam("code") String code) {
      String appid = this.weChatOAuthConfig.getClientId();
      String secret = this.weChatOAuthConfig.getClientSecret();
      String param = "appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
      String url = this.weChatOAuthConfig.getAccessTokenUri();
      String rspStr = HttpUtils.sendPost(url, param);
      JSONObject obj = JSONObject.parseObject(rspStr);
      url = this.weChatOAuthConfig.getUserInfoUri();
      String openid = obj.getString("openid");
      String access_token = obj.getString("access_token");
      String refresh_token = obj.getString("refresh_token");
      param = "access_token=" + access_token + "&openid=" + openid + "&lang=zh_CN";
      rspStr = HttpUtils.sendPost(url, param);
      UserWechat userWechat = (UserWechat)JSON.parseObject(rspStr, UserWechat.class);
      userWechat.setOpenId(openid);
      WechatAuthResult wechatAuthResult = new WechatAuthResult();
      wechatAuthResult.setAccessToken(access_token);
      wechatAuthResult.setRefreshToken(refresh_token);
      wechatAuthResult.setUserInfo(userWechat);
      UserWechat userWechatForDB = this.userWechatService.selectUserWechatByOpenId(openid);
      if (userWechatForDB == null) {
         userWechat.setCreateTime(new Date());
         userWechat.setAppId(appid);
         int var14 = this.userWechatService.insertUserWechat(userWechat);
      }

      return AjaxResult.success(wechatAuthResult);
   }

   @GetMapping({"/info"})
   public Object userInfo(@AuthenticationPrincipal Object object) {
      return object;
   }
}
