package com.wechat.project.operation.controller;

import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.basis.domain.Operation;
import com.wechat.project.operation.domain.AddOperationAuth;
import com.wechat.project.operation.domain.EmpLinkOperation;
import com.wechat.project.operation.service.IEmpLinkOperationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/operation/operationLevel"})
public class EmpLinkOperationController extends BaseController {
   @Autowired
   private IEmpLinkOperationService empLinkOperationService;

   @PreAuthorize("@ss.hasPermi('operation:operationLevel:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(EmpLinkOperation empLinkOperation) {
      this.startPage();
      List<EmpLinkOperation> list = this.empLinkOperationService.selectEmpLinkOperationList(empLinkOperation);
      return this.getDataTable(list);
   }

   @PreAuthorize("@ss.hasPermi('operation:operationLevel:export')")
   @Log(
      title = "手术分级",
      businessType = BusinessType.EXPORT
   )
   @GetMapping({"/export"})
   public AjaxResult export(EmpLinkOperation empLinkOperation) {
      List<EmpLinkOperation> list = this.empLinkOperationService.selectEmpLinkOperationList(empLinkOperation);
      ExcelUtil<EmpLinkOperation> util = new ExcelUtil<>(EmpLinkOperation.class);
      return util.exportExcel(list, "operationLevel");
   }

   @PreAuthorize("@ss.hasPermi('operation:operationLevel:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable("id") Long id) {
      return AjaxResult.success(this.empLinkOperationService.selectEmpLinkOperationById(id));
   }

   @PreAuthorize("@ss.hasPermi('operation:operationLevel:edit')")
   @Log(
      title = "手术分级",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@RequestBody EmpLinkOperation empLinkOperation) {
      return this.toAjax(this.empLinkOperationService.updateEmpLinkOperation(empLinkOperation));
   }

   @PreAuthorize("@ss.hasPermi('operation:operationLevel:remove')")
   @Log(
      title = "手术分级",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.empLinkOperationService.deleteEmpLinkOperationByIds(ids));
   }

   @GetMapping({"getDeptAndEmpTree"})
   public AjaxResult getDeptAndEmpTree() {
      Object areaList = this.empLinkOperationService.selectDeptAndEmpTree();
      return AjaxResult.success(areaList);
   }

   @Log(
      title = "手术分级",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@RequestBody AddOperationAuth addOperationAuth) {
      return this.empLinkOperationService.insertEmpLinkOperation(addOperationAuth);
   }

   @GetMapping({"/getUseLinkOperation"})
   public TableDataInfo selectUseLinkOperation(EmpLinkOperation empLinkOperation) {
      this.startPage();
      List<Operation> list = this.empLinkOperationService.selectUseLinkOperation(empLinkOperation);
      return this.getDataTable(list);
   }

   @GetMapping({"/getUnLinkOperation"})
   public TableDataInfo selectUnLinkOperation(EmpLinkOperation empLinkOperation) {
      this.startPage();
      List<Operation> list = this.empLinkOperationService.selectUnLinkOperation(empLinkOperation);
      return this.getDataTable(list);
   }

   @GetMapping({"/getUnLinkOperationtow"})
   public TableDataInfo selectUnLinkOperationtow(EmpLinkOperation empLinkOperation) {
      System.out.println("================================================>");
      System.out.println(empLinkOperation);
      this.startPage();
      List<Operation> list = this.empLinkOperationService.selectUnLinkOperationtow(empLinkOperation);
      return this.getDataTable(list);
   }

   @PostMapping({"/deleteEmpLinkOperationByModel"})
   public AjaxResult deleteEmpLinkOperationByModel(@RequestBody AddOperationAuth addOperationAuth) {
      return this.toAjax(this.empLinkOperationService.deleteEmpLinkOperationByModel(addOperationAuth));
   }
}
