package com.wechat.project.operation.service.impl;

import com.alibaba.fastjson.JSON;
import com.wechat.common.utils.DateUtils;
import com.wechat.common.webserviceClient.XhWebServiceClient;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.project.basis.domain.Operation;
import com.wechat.project.operation.domain.AddOperationAuth;
import com.wechat.project.operation.domain.DeptEmpTree;
import com.wechat.project.operation.domain.EmpLinkOperation;
import com.wechat.project.operation.domain.OperationAuthMain;
import com.wechat.project.operation.domain.OperationAuthToPlatform;
import com.wechat.project.operation.domain.PlatformParam;
import com.wechat.project.operation.mapper.EmpLinkOperationMapper;
import com.wechat.project.operation.service.IEmpLinkOperationService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpLinkOperationServiceImpl implements IEmpLinkOperationService {
   @Autowired
   private EmpLinkOperationMapper empLinkOperationMapper;

   @Override
   public EmpLinkOperation selectEmpLinkOperationById(Long id) {
      return this.empLinkOperationMapper.selectEmpLinkOperationById(id);
   }

   @Override
   public List<EmpLinkOperation> selectEmpLinkOperationList(EmpLinkOperation empLinkOperation) {
      return this.empLinkOperationMapper.selectEmpLinkOperationList(empLinkOperation);
   }

   @Override
   public AjaxResult insertEmpLinkOperation(AddOperationAuth addOperationAuth) {
      int n = 0;
      EmpLinkOperation empLinkOperation = new EmpLinkOperation();
      empLinkOperation.setEmpCode(addOperationAuth.getEmpCode());
      List<Operation> operationList = addOperationAuth.getOperationList();
      OperationAuthMain operationAuthMain = new OperationAuthMain();
      PlatformParam platformParam = new PlatformParam();
      List<OperationAuthToPlatform> list = new ArrayList<>();
      platformParam.setDatasetcode("D02950");
      platformParam.setSourceid("SSFJ");
      platformParam.setSourcetype("I");

      for (Operation item : operationList) {
         empLinkOperation.setOperationCode(item.getOpsCode());
         empLinkOperation.setOperationLevel(item.getOperationLevel());
         empLinkOperation.setOperationName(item.getOpsName());
         empLinkOperation.setSpell(item.getSpell());
         OperationAuthToPlatform operationAuthToPlatform = new OperationAuthToPlatform();
         operationAuthToPlatform.setCreateTime(DateUtils.getTime());
         operationAuthToPlatform.setEmpCode(addOperationAuth.getEmpCode());
         operationAuthToPlatform.setMainKey(addOperationAuth.getEmpCode() + "_" + item.getOpsCode());
         operationAuthToPlatform.setOpsCode(item.getOpsCode());
         operationAuthToPlatform.setOpsLevel(item.getOperationLevel());
         operationAuthToPlatform.setOpsName(item.getOpsName());
         operationAuthToPlatform.setSpell(item.getSpell());
         list.add(operationAuthToPlatform);
         if (item.getOperationLevel() == null || "".equals(item.getOperationLevel())) {
            return AjaxResult.error("授权的手术等级不能为空！");
         }

         n += this.empLinkOperationMapper.insertEmpLinkOperation(empLinkOperation);
      }

      if (n > 0) {
         try {
            operationAuthMain.setParam(platformParam);
            operationAuthMain.setOperationAuthToPlatforms(list);
            String str = JSON.toJSONString(operationAuthMain);
            String result = XhWebServiceClient.SubWebService(JSON.toJSONString(operationAuthMain));
            System.out.println("调用发布数据结果---" + result);
         } catch (Exception var11) {
            System.out.println("调用发布数据出错:" + var11);
         }
      }

      return AjaxResult.success();
   }

   @Override
   public int updateEmpLinkOperation(EmpLinkOperation empLinkOperation) {
      return this.empLinkOperationMapper.updateEmpLinkOperation(empLinkOperation);
   }

   @Override
   public int deleteEmpLinkOperationByIds(Long[] ids) {
      return this.empLinkOperationMapper.deleteEmpLinkOperationByIds(ids);
   }

   @Override
   public int deleteEmpLinkOperationById(Long id) {
      return this.empLinkOperationMapper.deleteEmpLinkOperationById(id);
   }

   @Override
   public List<DeptEmpTree> selectDeptAndEmpTree() {
      List<DeptEmpTree> deptList = this.empLinkOperationMapper.selectDeptList();
      List<DeptEmpTree> empList = this.empLinkOperationMapper.selectEmpList();

      for (DeptEmpTree dItem : deptList) {
         List<DeptEmpTree> eList = empList.stream().filter(c -> c.getPId().equals(dItem.getId())).collect(Collectors.toList());
         dItem.setChildren(eList);
      }

      return deptList;
   }

   @Override
   public List<Operation> selectUnLinkOperation(EmpLinkOperation empLinkOperation) {
      System.out.println(empLinkOperation);
      return this.empLinkOperationMapper.selectUnLinkOperation(empLinkOperation);
   }

   @Override
   public List<Operation> selectUnLinkOperationtow(EmpLinkOperation empLinkOperation) {
      return this.empLinkOperationMapper.selectUnLinkOperationtow(empLinkOperation);
   }

   @Override
   public List<Operation> selectUseLinkOperation(EmpLinkOperation empLinkOperation) {
      return this.empLinkOperationMapper.selectUseLinkOperation(empLinkOperation);
   }

   @Override
   public int deleteEmpLinkOperationByModel(AddOperationAuth addOperationAuth) {
      int n = 0;
      EmpLinkOperation empLinkOperation = new EmpLinkOperation();
      empLinkOperation.setEmpCode(addOperationAuth.getEmpCode());
      List<Operation> operationList = addOperationAuth.getOperationList();
      OperationAuthMain operationAuthMain = new OperationAuthMain();
      PlatformParam platformParam = new PlatformParam();
      platformParam.setDatasetcode("D02950");
      platformParam.setSourceid("SSFJ");
      platformParam.setSourcetype("D");

      for (Operation item : operationList) {
         List<OperationAuthToPlatform> list = new ArrayList<>();
         System.out.println(list);
         empLinkOperation.setOperationCode(item.getOpsCode());
         empLinkOperation.setOperationLevel(item.getOperationLevel());
         empLinkOperation.setOperationName(item.getOpsName());
         empLinkOperation.setSpell(item.getSpell());
         OperationAuthToPlatform operationAuthToPlatform = new OperationAuthToPlatform();
         operationAuthToPlatform.setCreateTime(DateUtils.getTime());
         operationAuthToPlatform.setEmpCode(addOperationAuth.getEmpCode());
         operationAuthToPlatform.setMainKey(addOperationAuth.getEmpCode() + "_" + item.getOpsCode());
         operationAuthToPlatform.setOpsCode(item.getOpsCode());
         operationAuthToPlatform.setOpsLevel(item.getOperationLevel());
         operationAuthToPlatform.setOpsName(item.getOpsName());
         operationAuthToPlatform.setSpell(item.getSpell());
         list.add(operationAuthToPlatform);
         n += this.empLinkOperationMapper.deleteEmpLinkOperationByModel(empLinkOperation);
         if (n > 0) {
            try {
               operationAuthMain.setParam(platformParam);
               operationAuthMain.setOperationAuthToPlatforms(list);
               String str = JSON.toJSONString(operationAuthMain);
               String result = XhWebServiceClient.SubWebService(JSON.toJSONString(operationAuthMain));
               System.out.println("调用发布数据结果---" + result);
            } catch (Exception var13) {
               System.out.println("调用发布数据出错:" + var13);
            }
         }
      }

      return n;
   }
}
