package com.wechat.project.system.controller;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.ServletUtils;
import com.wechat.common.utils.file.FileUploadUtils;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.config.WechatConfig;
import com.wechat.framework.security.LoginUser;
import com.wechat.framework.security.service.TokenService;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.project.system.domain.SysUser;
import com.wechat.project.system.service.ISysUserService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping({"/system/user/profile"})
public class SysProfileController extends BaseController {
   @Autowired
   private ISysUserService userService;
   @Autowired
   private TokenService tokenService;

   @GetMapping
   public AjaxResult profile() {
      LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
      SysUser user = loginUser.getUser();
      AjaxResult ajax = AjaxResult.success(user);
      ajax.put("roleGroup", this.userService.selectUserRoleGroup(loginUser.getUsername()));
      ajax.put("postGroup", this.userService.selectUserPostGroup(loginUser.getUsername()));
      return ajax;
   }

   @Log(
      title = "个人信息",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult updateProfile(@RequestBody SysUser user) {
      return this.toAjax(this.userService.updateUserProfile(user));
   }

   @Log(
      title = "个人信息",
      businessType = BusinessType.UPDATE
   )
   @PutMapping({"/updatePwd"})
   public AjaxResult updatePwd(String oldPassword, String newPassword) {
      LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
      String userName = loginUser.getUsername();
      String password = loginUser.getPassword();
      if (!SecurityUtils.matchesPassword(oldPassword, password)) {
         return AjaxResult.error("修改密码失败，旧密码错误");
      } else {
         return SecurityUtils.matchesPassword(newPassword, password)
            ? AjaxResult.error("新密码不能与旧密码相同")
            : this.toAjax(this.userService.resetUserPwd(userName, SecurityUtils.encryptPassword(newPassword)));
      }
   }

   @Log(
      title = "用户头像",
      businessType = BusinessType.UPDATE
   )
   @PostMapping({"/avatar"})
   public AjaxResult avatar(@RequestParam("avatarfile") MultipartFile file) throws IOException {
      if (!file.isEmpty()) {
         LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
         String avatar = FileUploadUtils.upload(WechatConfig.getAvatarPath(), file);
         if (this.userService.updateUserAvatar(loginUser.getUsername(), avatar)) {
            AjaxResult ajax = AjaxResult.success();
            ajax.put("imgUrl", avatar);
            return ajax;
         }
      }

      return AjaxResult.error("上传图片异常，请联系管理员");
   }
}
