package com.wechat.project.system.controller;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.system.domain.SysUserWechat;
import com.wechat.project.system.service.ISysUserWechatService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/system/userWechat"})
public class SysUserWechatController extends BaseController {
   @Autowired
   private ISysUserWechatService userWechatService;

   @PreAuthorize("@ss.hasPermi('system:userWechat:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(SysUserWechat userWechat) {
      this.startPage();
      List<SysUserWechat> list = this.userWechatService.selectUserWechatList(userWechat);
      return this.getDataTable(list);
   }

   @Log(
      title = "微信用户",
      businessType = BusinessType.EXPORT
   )
   @PreAuthorize("@ss.hasPermi('system:userWechat:export')")
   @GetMapping({"/export"})
   public AjaxResult export(SysUserWechat userWechat) {
      List<SysUserWechat> list = this.userWechatService.selectUserWechatList(userWechat);
      ExcelUtil<SysUserWechat> util = new ExcelUtil<>(SysUserWechat.class);
      return util.exportExcel(list, "微信用户");
   }

   @PreAuthorize("@ss.hasPermi('system:userWechat:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable Long id) {
      return AjaxResult.success(this.userWechatService.selectUserWechatById(id));
   }

   @PreAuthorize("@ss.hasPermi('system:userWechat:add')")
   @Log(
      title = "微信用户",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@Validated @RequestBody SysUserWechat userWechat) {
      userWechat.setCreateBy(SecurityUtils.getUsername());
      return this.toAjax(this.userWechatService.insertUserWechat(userWechat));
   }

   @PreAuthorize("@ss.hasPermi('system:userWechat:edit')")
   @Log(
      title = "微信用户管理",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@Validated @RequestBody SysUserWechat userWechat) {
      userWechat.setUpdateBy(SecurityUtils.getUsername());
      userWechat.setUpdateTime(new Date());
      return this.toAjax(this.userWechatService.updateUserWechat(userWechat));
   }

   @PreAuthorize("@ss.hasPermi('system:userWechat:remove')")
   @Log(
      title = "微信用户管理",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.userWechatService.deleteUserWechatByIds(ids));
   }
}
