package com.wechat.project.system.controller;

import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.system.domain.TestP;
import com.wechat.project.system.service.ITestPService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/system/p"})
public class TestPController extends BaseController {
   @Autowired
   private ITestPService testPService;

   @PreAuthorize("@ss.hasPermi('system:p:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(TestP testP) {
      this.startPage();
      List<TestP> list = this.testPService.selectTestPList(testP);
      return this.getDataTable(list);
   }

   @PreAuthorize("@ss.hasPermi('system:p:export')")
   @Log(
      title = "测试人员",
      businessType = BusinessType.EXPORT
   )
   @GetMapping({"/export"})
   public AjaxResult export(TestP testP) {
      List<TestP> list = this.testPService.selectTestPList(testP);
      ExcelUtil<TestP> util = new ExcelUtil<>(TestP.class);
      return util.exportExcel(list, "p");
   }

   @PreAuthorize("@ss.hasPermi('system:p:query')")
   @GetMapping({"/{pId}"})
   public AjaxResult getInfo(@PathVariable("pId") Long pId) {
      return AjaxResult.success(this.testPService.selectTestPById(pId));
   }

   @PreAuthorize("@ss.hasPermi('system:p:add')")
   @Log(
      title = "测试人员",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@RequestBody TestP testP) {
      return this.toAjax(this.testPService.insertTestP(testP));
   }

   @PreAuthorize("@ss.hasPermi('system:p:edit')")
   @Log(
      title = "测试人员",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@RequestBody TestP testP) {
      return this.toAjax(this.testPService.updateTestP(testP));
   }

   @PreAuthorize("@ss.hasPermi('system:p:remove')")
   @Log(
      title = "测试人员",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{pIds}"})
   public AjaxResult remove(@PathVariable Long[] pIds) {
      return this.toAjax(this.testPService.deleteTestPByIds(pIds));
   }
}
