package com.wechat.project.system.service.impl;

import com.wechat.common.utils.StringUtils;
import com.wechat.project.system.domain.SysDictType;
import com.wechat.project.system.mapper.SysDictDataMapper;
import com.wechat.project.system.mapper.SysDictTypeMapper;
import com.wechat.project.system.service.ISysDictTypeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDictTypeServiceImpl implements ISysDictTypeService {
   @Autowired
   private SysDictTypeMapper dictTypeMapper;
   @Autowired
   private SysDictDataMapper dictDataMapper;

   @Override
   public List<SysDictType> selectDictTypeList(SysDictType dictType) {
      return this.dictTypeMapper.selectDictTypeList(dictType);
   }

   @Override
   public List<SysDictType> selectDictTypeAll() {
      return this.dictTypeMapper.selectDictTypeAll();
   }

   @Override
   public SysDictType selectDictTypeById(Long dictId) {
      return this.dictTypeMapper.selectDictTypeById(dictId);
   }

   @Override
   public SysDictType selectDictTypeByType(String dictType) {
      return this.dictTypeMapper.selectDictTypeByType(dictType);
   }

   @Override
   public int deleteDictTypeById(Long dictId) {
      return this.dictTypeMapper.deleteDictTypeById(dictId);
   }

   @Override
   public int deleteDictTypeByIds(Long[] dictIds) {
      return this.dictTypeMapper.deleteDictTypeByIds(dictIds);
   }

   @Override
   public int insertDictType(SysDictType dictType) {
      return this.dictTypeMapper.insertDictType(dictType);
   }

   @Transactional
   @Override
   public int updateDictType(SysDictType dictType) {
      SysDictType oldDict = this.dictTypeMapper.selectDictTypeById(dictType.getDictId());
      this.dictDataMapper.updateDictDataType(oldDict.getDictType(), dictType.getDictType());
      return this.dictTypeMapper.updateDictType(dictType);
   }

   @Override
   public String checkDictTypeUnique(SysDictType dict) {
      Long dictId = StringUtils.isNull(dict.getDictId()) ? -1L : dict.getDictId();
      SysDictType dictType = this.dictTypeMapper.checkDictTypeUnique(dict.getDictType());
      return StringUtils.isNotNull(dictType) && dictType.getDictId() != dictId ? "1" : "0";
   }
}
