package com.wechat.common.webserviceClient;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.springframework.stereotype.Component;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;

@Component
@Slf4j
public class XhWebServiceClient {

   public static String SubWebService(String map) throws Exception {
      String requestXml = JSONObject.toJSON(map).toString();
       log.info("调用esb发布数据集服务:{}", requestXml);
      String responseXml = "";

      try {
         String endpoint = "http://10.0.10.18:8080/datacenter/rpc/webservice/SubscriptionService?wsdl";
         String webServiceNameSpace = "http://webservice.rpc.win.org/";
         String webServiceMethod = "saveDataSetJson";
         Service service = new Service();
         Call call = (Call)service.createCall();
         call.setTargetEndpointAddress(endpoint);
         call.setOperationName(new QName(webServiceNameSpace, webServiceMethod));
         call.addParameter("arg0", XMLType.XSD_STRING, ParameterMode.IN);
         call.setReturnType(XMLType.XSD_STRING);
         return (String)call.invoke(new Object[]{requestXml});
      } catch (ServiceException var8) {
         var8.printStackTrace();
         log.error("调用发布数据接口异常:{}", var8.getMessage());
         throw new ServiceException("请求webservice服务异常", var8);
      }
   }

   public static String SubWebServiceBySSO(String map) throws Exception {
      String requestXml = JSONObject.toJSON(map).toString();
      System.out.println("调用单点登录服务:" + requestXml);
      String responseXml = "";

      try {
         String endpoint = "http://10.0.10.7:8283/SSOWebService.asmx?wsdl";
         String webServiceNameSpace = "http://tempuri.org/";
         String webServiceMethod = "GetSSOToken";
         Service service = new Service();
         Call call = (Call)service.createCall();
         call.setTargetEndpointAddress(endpoint);
         call.setOperationName(new QName(webServiceNameSpace, webServiceMethod));
         call.addParameter("arg0", XMLType.XSD_STRING, ParameterMode.IN);
         call.setReturnType(XMLType.XSD_STRING);
         responseXml = (String)call.invoke(new Object[]{requestXml});
         System.out.println("调用单点登录数据结果：" + responseXml);
         return responseXml;
      } catch (ServiceException var8) {
         var8.printStackTrace();
         System.out.println("调用单点登录数据接口异常:" + var8.getMessage());
         throw new ServiceException("调用单点登录服务异常", var8);
      }
   }


}
