package com.wechat.framework.security.handle;

import com.alibaba.fastjson.JSON;
import com.wechat.common.utils.ServletUtils;
import com.wechat.common.utils.StringUtils;
import com.wechat.framework.manager.AsyncManager;
import com.wechat.framework.manager.factory.AsyncFactory;
import com.wechat.framework.security.LoginUser;
import com.wechat.framework.security.service.TokenService;
import com.wechat.framework.web.domain.AjaxResult;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
public class LogoutSuccessHandlerImpl implements LogoutSuccessHandler {
   @Autowired
   private TokenService tokenService;

   public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
      LoginUser loginUser = this.tokenService.getLoginUser(request);
      if (StringUtils.isNotNull(loginUser)) {
         String userName = loginUser.getUsername();
         AsyncManager.me().execute(AsyncFactory.recordLogininfor(userName, "Logout", "退出成功"));
      }

      ServletUtils.renderString(response, JSON.toJSONString(AjaxResult.error(200, "退出成功")));
   }
}
