package com.wechat.framework.security.service;

import com.wechat.project.system.domain.SysUser;
import com.wechat.project.system.service.ISysMenuService;
import com.wechat.project.system.service.ISysRoleService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysPermissionService {
   @Autowired
   private ISysRoleService roleService;
   @Autowired
   private ISysMenuService menuService;

   public Set<String> getRolePermission(SysUser user) {
      Set<String> roles = new HashSet<>();
      if (user.isAdmin()) {
         roles.add("admin");
      } else {
         roles.addAll(this.roleService.selectRolePermissionByUserId(user.getUserId()));
      }

      return roles;
   }

   public Set<String> getMenuPermission(SysUser user) {
      Set<String> roles = new HashSet<>();
      if (user.isAdmin()) {
         roles.add("*:*:*");
      } else {
         roles.addAll(this.menuService.selectMenuPermsByUserId(user.getUserId()));
      }

      return roles;
   }
}
