package com.wechat.project.basis.mapper;

import com.wechat.project.basis.domain.Operation;
import com.wechat.project.operation.domain.EmpLinkOperation;

import java.util.List;

public interface OperationMapper {
   Operation selectOperationById(Long id);

   List<Operation> selectOperationList(Operation operation);

   int insertOperation(Operation operation);

   int updateOperation(Operation operation);

   int deleteOperationById(Long id);

   int deleteOperationByIds(Long[] ids);

   int deleteOperationByCode(String opsCode);

   int selectCountOperation(String opsCode);

   /**
    * 查询所有绑定过的此手术的信息
    * @param opsCode
    * @return
    */
   List<EmpLinkOperation> selectBindOperationEmp(String opsCode);

   /**
    * 查询所有
    * @param opsCode
    * @return
    */
   List<EmpLinkOperation> selectAllOperationEmp();

   /**
    * 手术分级修改之后对绑定数据进行更新
    * @param operation
    * @return
    */
   int updateEmpLinkById(EmpLinkOperation operation);
}
