package com.wechat.project.basis.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.wechat.common.utils.DateUtils;
import com.wechat.common.webserviceClient.XhWebServiceClient;
import com.wechat.project.basis.domain.*;
import com.wechat.project.basis.mapper.DeptMapper;
import com.wechat.project.basis.mapper.EmpMapper;
import com.wechat.project.basis.mapper.OperationMapper;
import com.wechat.project.basis.service.IOperationService;
import com.wechat.project.operation.domain.EmpLinkOperation;
import com.wechat.project.operation.domain.OperationAuthMain;
import com.wechat.project.operation.domain.OperationAuthToPlatform;
import com.wechat.project.operation.domain.PlatformParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class OperationServiceImpl implements IOperationService {
   @Autowired
   private OperationMapper operationMapper;
   @Autowired
   private EmpMapper empMapper;
   @Autowired
   private DeptMapper deptMapper;

   @Override
   public String mainService(String request) {
      long start = System.currentTimeMillis();
      System.out.println(request);
      System.out.println("进入接口时间日期：-->" + DateUtils.getTime());
      PTResponse rs = new PTResponse();
      if (!request.isEmpty() && request != null) {
         try {
            new DataSourceByPT();
            DataSourceByPT e = (DataSourceByPT)JSON.parseObject(request, DataSourceByPT.class);
            String datasetcode = e.getMainParameters().getDatasetcode();
            switch (datasetcode) {
               case "D03015":
                  return this.takeOperationInfo(request);
               case "D02002":
                  return this.takeDeptInfo(request);
               case "D02003":
                  return this.takeUserInfo(request);
               default:
                  rs.setErrorNo("0");
                  rs.setErrorMessage("非订阅数据，接口未做处理");
                  return JSON.toJSONString(rs);
            }
         } catch (Exception var9) {
            rs.setErrorNo("0");
            rs.setErrorMessage("系统报错：" + var9.getMessage());
            return JSON.toJSONString(rs);
         }
      } else {
         rs.setErrorNo("-1");
         rs.setErrorMessage("入参为null");
         return JSON.toJSONString(rs);
      }
   }

   public String takeOperationInfo(String request) {
      System.out.println(DateUtils.getTime() + "进入订阅手术字典接口");
      PTResponse rs = new PTResponse();
      OperationMainInfo operationMainInfo = (OperationMainInfo)JSON.parseObject(request, OperationMainInfo.class);
      int n = 0;
      if (operationMainInfo == null) {
         rs.setErrorNo("0");
         rs.setErrorMessage("入参有误！");
      } else {
         MainParameters mainParameters = operationMainInfo.getMainParameters();
         if (!mainParameters.getSourceType().equals("I") && !mainParameters.getSourceType().equals("U")) {
            if (mainParameters.getSourceType().equals("D")) {
               for (Operation item : operationMainInfo.getList()) {
                  n += this.operationMapper.deleteOperationByCode(item.getOpsCode());
               }
            }
         } else {
            for (Operation item : operationMainInfo.getList()) {
               if (this.operationMapper.selectCountOperation(item.getOpsCode()) > 0) {
                  this.operationMapper.deleteOperationByCode(item.getOpsCode());
                  n += this.insertOperation(item);
               } else {
                  n += this.insertOperation(item);
               }
            }
         }
      }

      if (n > 0) {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作成功！");
      } else {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作失败！");
      }

      return JSON.toJSONString(rs);
   }

   public String takeDeptInfo(String request) {
      System.out.println(DateUtils.getTime() + "进入订阅科室接口");
      PTResponse rs = new PTResponse();
      DeptMainInfo deptMainInfo = (DeptMainInfo)JSON.parseObject(request, DeptMainInfo.class);
      int n = 0;
      if (deptMainInfo == null) {
         rs.setErrorNo("0");
         rs.setErrorMessage("入参有误！");
      } else {
         MainParameters mainParameters = deptMainInfo.getMainParameters();
         List<Dept> list = deptMainInfo.getList();
         if (!mainParameters.getSourceType().equals("I") && !mainParameters.getSourceType().equals("U")) {
            if (mainParameters.getSourceType().equals("D")) {
               for (Dept item : list) {
                  n += this.deptMapper.deleteDeptByCode(item.getDeptCode());
               }
            }
         } else {
            for (Dept item : list) {
               if (this.deptMapper.selectCountDept(item.getDeptCode()) > 0) {
                  this.deptMapper.deleteDeptByCode(item.getDeptCode());
                  n += this.deptMapper.insertDept(item);
               } else {
                  n += this.deptMapper.insertDept(item);
               }
            }
         }
      }

      if (n > 0) {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作成功！");
      } else {
         rs.setErrorNo("-1");
         rs.setErrorMessage("操作失败！");
      }

      return JSON.toJSONString(rs);
   }

   public String takeUserInfo(String request) {
      System.out.println(DateUtils.getTime() + "进入订阅人员接口");
      PTResponse rs = new PTResponse();
      UserMainInfo userMainInfo = (UserMainInfo)JSON.parseObject(request, UserMainInfo.class);
      int n = 0;
      if (userMainInfo == null) {
         rs.setErrorNo("-1");
         rs.setErrorMessage("入参有误！");
      } else {
         MainParameters mainParameters = userMainInfo.getMainParameters();
         List<Emp> list = userMainInfo.getList();
         if (!mainParameters.getSourceType().equals("I") && !mainParameters.getSourceType().equals("U")) {
            if (mainParameters.getSourceType().equals("D")) {
               for (Emp item : list) {
                  n += this.empMapper.deleteEmpByCode(item.getEmpCode());
               }
            }
         } else {
            for (Emp item : list) {
               if (this.empMapper.selectEmpCountByCode(item.getEmpCode()) > 0) {
                  this.empMapper.deleteEmpByCode(item.getEmpCode());
                  n += this.empMapper.insertEmp(item);
               } else {
                  n += this.empMapper.insertEmp(item);
               }
            }
         }
      }

      if (n > 0) {
         rs.setErrorNo("0");
         rs.setErrorMessage("操作成功！");
      } else {
         rs.setErrorNo("-1");
         rs.setErrorMessage("操作失败！");
      }

      return JSON.toJSONString(rs);
   }

   @Override
   public Operation selectOperationById(Long id) {
      return this.operationMapper.selectOperationById(id);
   }

   @Override
   public List<Operation> selectOperationList(Operation operation) {
      return this.operationMapper.selectOperationList(operation);
   }

   @Override
   public int insertOperation(Operation operation) {
      return this.operationMapper.insertOperation(operation);
   }

   @Override
   public int updateOperation(Operation operation) {
      Operation oldOperation = selectOperationById(operation.getId());
      this.operationMapper.updateOperation(operation);
      // 更新手术等级是需要重新发送给平台消息的
      // 查询已经绑定过此手术的所有授权
      // 判断是否更新了手术分级
      if (!StrUtil.equals(operation.getOpsName(),oldOperation.getOpsName()) || !StrUtil.equals(operation.getOperationLevel(),oldOperation.getOperationLevel())) {
         List<EmpLinkOperation> empLinkOperations = operationMapper.selectBindOperationEmp(operation.getOpsCode());
         OperationAuthMain operationAuthMain = new OperationAuthMain();
         PlatformParam platformParam = new PlatformParam();
         platformParam.setDatasetcode("D02950");
         platformParam.setSourceid("SSFJ");
         platformParam.setSourcetype("U");
         empLinkOperations.forEach(empLinkOperation -> {
            // 更新手术信息
            empLinkOperation.setOperationName(operation.getOpsName());
            empLinkOperation.setOperationLevel(operation.getOperationLevel());
            empLinkOperation.setSpell(operation.getSpell());
            operationMapper.updateEmpLinkById(empLinkOperation);
            // 平台消息推送
            try {
               OperationAuthToPlatform operationAuthToPlatform = new OperationAuthToPlatform();
               operationAuthToPlatform.setCreateTime(DateUtils.getTime());
               operationAuthToPlatform.setEmpCode(empLinkOperation.getEmpCode());
               operationAuthToPlatform.setMainKey(empLinkOperation.getEmpCode() + "_" + empLinkOperation.getOperationCode());
               operationAuthToPlatform.setOpsCode(empLinkOperation.getOperationCode());
               operationAuthToPlatform.setOpsLevel(empLinkOperation.getOperationLevel());
               operationAuthToPlatform.setOpsName(empLinkOperation.getOperationName());
               operationAuthToPlatform.setSpell(empLinkOperation.getSpell());
               operationAuthMain.setParam(platformParam);
               operationAuthMain.setOperationAuthToPlatforms(CollectionUtil.toList(operationAuthToPlatform));
               String result = XhWebServiceClient.SubWebService(JSON.toJSONString(operationAuthMain));
               log.info("手术分级联动授权更新平台发布结果:{}",result);
            }catch (Exception e){
               log.error("平台消息推送失败",e);
            }
         });
      }
      return 1;
   }

   @Override
   public int deleteOperationByIds(Long[] ids) {
      return this.operationMapper.deleteOperationByIds(ids);
   }

   @Override
   public int deleteOperationById(Long id) {
      return this.operationMapper.deleteOperationById(id);
   }
}
