package com.wechat.project.monitor.controller;

import com.wechat.common.exception.job.TaskException;
import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.monitor.domain.SysJob;
import com.wechat.project.monitor.service.ISysJobService;
import java.util.List;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/monitor/job"})
public class SysJobController extends BaseController {
   @Autowired
   private ISysJobService jobService;

   @PreAuthorize("@ss.hasPermi('monitor:job:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(SysJob sysJob) {
      this.startPage();
      List<SysJob> list = this.jobService.selectJobList(sysJob);
      return this.getDataTable(list);
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:export')")
   @Log(
      title = "定时任务",
      businessType = BusinessType.EXPORT
   )
   @GetMapping({"/export"})
   public AjaxResult export(SysJob sysJob) {
      List<SysJob> list = this.jobService.selectJobList(sysJob);
      ExcelUtil<SysJob> util = new ExcelUtil<>(SysJob.class);
      return util.exportExcel(list, "定时任务");
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:query')")
   @GetMapping({"/{jobId}"})
   public AjaxResult getInfo(@PathVariable("jobId") Long jobId) {
      return AjaxResult.success(this.jobService.selectJobById(jobId));
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:add')")
   @Log(
      title = "定时任务",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@RequestBody SysJob sysJob) throws SchedulerException, TaskException {
      return this.toAjax(this.jobService.insertJob(sysJob));
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:edit')")
   @Log(
      title = "定时任务",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@RequestBody SysJob sysJob) throws SchedulerException, TaskException {
      return this.toAjax(this.jobService.updateJob(sysJob));
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:changeStatus')")
   @Log(
      title = "定时任务",
      businessType = BusinessType.UPDATE
   )
   @PutMapping({"/changeStatus"})
   public AjaxResult changeStatus(@RequestBody SysJob job) throws SchedulerException {
      SysJob newJob = this.jobService.selectJobById(job.getJobId());
      newJob.setStatus(job.getStatus());
      return this.toAjax(this.jobService.changeStatus(newJob));
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:changeStatus')")
   @Log(
      title = "定时任务",
      businessType = BusinessType.UPDATE
   )
   @PutMapping({"/run"})
   public AjaxResult run(@RequestBody SysJob job) throws SchedulerException {
      this.jobService.run(job);
      return AjaxResult.success();
   }

   @PreAuthorize("@ss.hasPermi('monitor:job:remove')")
   @Log(
      title = "定时任务",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{jobIds}"})
   public AjaxResult remove(@PathVariable Long[] jobIds) throws SchedulerException, TaskException {
      this.jobService.deleteJobByIds(jobIds);
      return AjaxResult.success();
   }
}
