package com.wechat.project.operation.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.wechat.common.utils.DateUtils;
import com.wechat.common.webserviceClient.XhWebServiceClient;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.project.basis.mapper.OperationMapper;
import com.wechat.project.operation.domain.*;
import com.wechat.project.operation.service.IEmpLinkOperationService;
import com.wechat.project.system.domain.SysMenu;
import com.wechat.project.system.domain.vo.RouterVo;
import com.wechat.project.system.mapper.SysMenuMapper;
import com.wechat.project.system.service.ISysMenuService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping({"/open"})
@Slf4j
public class OpenController extends BaseController {
   @Autowired
   private IEmpLinkOperationService empLinkOperationService;

   @Autowired
   private OperationMapper operationMapper;

   @Autowired
   private SysMenuMapper menuMapper;

   @Autowired
   private ISysMenuService menuService;

   public static volatile  int flag = 0;

   @GetMapping({"/init"})
   public AjaxResult initAllEmpLink() {
      if (flag == 1){
         return AjaxResult.success("初始化任务正在执行,请不要重复调用");
      }
      flag = 1;
      new Thread(()->{
         OperationAuthMain operationAuthMain = new OperationAuthMain();
         PlatformParam platformParam = new PlatformParam();
         platformParam.setDatasetcode("D02950");
         platformParam.setSourceid("SSFJ");
         platformParam.setSourcetype("U");
         try {
            List<EmpLinkOperation> linkOperations = operationMapper.selectAllOperationEmp();
            linkOperations.forEach(operation -> {
               OperationAuthToPlatform operationAuthToPlatform = new OperationAuthToPlatform();
               operationAuthToPlatform.setCreateTime(DateUtils.getTime());
               operationAuthToPlatform.setEmpCode(operation.getEmpCode());
               operationAuthToPlatform.setMainKey(operation.getEmpCode() + "_" + operation.getOperationCode());
               operationAuthToPlatform.setOpsCode(operation.getOperationCode());
               operationAuthToPlatform.setOpsLevel(operation.getOperationLevel());
               operationAuthToPlatform.setOpsName(operation.getOperationName());
               operationAuthToPlatform.setSpell(operation.getSpell());
               operationAuthMain.setParam(platformParam);
               operationAuthMain.setOperationAuthToPlatforms(CollectionUtil.toList(operationAuthToPlatform));
                String result = null;
                try {
                    result = XhWebServiceClient.SubWebService(JSON.toJSONString(operationAuthMain));
                } catch (Exception e) {
                   log.error("平台消息推送失败",e);
                }
                log.info("手术分级联动授权更新平台发布结果:{}",result);
            });
         }catch (Exception e){
            log.error("初始化授权失败",e);
         }finally {
            flag = 0;
         }
      }).start();
      return AjaxResult.success("正在推送数据,请不要重复刷新或调用");
   }

   @GetMapping({"/test"})
   public AjaxResult test(){

      List<SysMenu> menus = this.menuMapper.selectMenuTreeAll();
      List<SysMenu> childPerms = this.getChildPerms(menus, 0);
      List<RouterVo> routerVos = this.menuService.buildMenus(childPerms);
      log.info(routerVos.toString());
      return AjaxResult.success();
   }

   public List<SysMenu> getChildPerms(List<SysMenu> list, int parentId) {
      List<SysMenu> returnList = new ArrayList<>();

      for (SysMenu t : list) {
         if (t.getParentId() == (long)parentId) {
            this.recursionFn(list, t);
            returnList.add(t);
         }
      }

      return returnList;
   }

   private void recursionFn(List<SysMenu> list, SysMenu t) {
      List<SysMenu> childList = this.getChildList(list, t);
      t.setChildren(childList);

      for (SysMenu tChild : childList) {
         if (this.hasChild(list, tChild)) {
            for (SysMenu n : childList) {
               this.recursionFn(list, n);
            }
         }
      }
   }

   private boolean hasChild(List<SysMenu> list, SysMenu t) {
      return this.getChildList(list, t).size() > 0;
   }

   private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
      List<SysMenu> tlist = new ArrayList<>();

      for (SysMenu n : list) {
         if (n.getParentId() == t.getMenuId()) {
            tlist.add(n);
         }
      }

      return tlist;
   }

}
