package com.wechat.project.system.mapper;

import com.wechat.project.system.domain.SysDept;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface SysDeptMapper {
   List<SysDept> selectDeptList(SysDept dept);

   List<SysDept> selectDeptInfo();

   List<SysDept> getHspOption();

   List<SysDept> getDeptOption(SysDept deptInfo);

   List<Integer> selectDeptListByRoleId(Long roleId);

   SysDept selectDeptById(Long deptId);

   List<SysDept> selectChildrenDeptById(Long deptId);

   int hasChildByDeptId(Long deptId);

   int checkDeptExistUser(Long deptId);

   SysDept checkDeptNameUnique(@Param("deptName") String deptName, @Param("parentId") Long parentId);

   int insertDept(SysDept dept);

   int updateDept(SysDept dept);

   void updateDeptStatus(SysDept dept);

   int updateDeptChildren(@Param("depts") List<SysDept> depts);

   int deleteDeptById(Long deptId);
}
