package com.wechat.project.system.service;

import com.wechat.project.system.domain.SysRole;
import java.util.List;
import java.util.Set;

public interface ISysRoleService {
   List<SysRole> selectRoleList(SysRole role);

   Set<String> selectRolePermissionByUserId(Long userId);

   List<SysRole> selectRoleAll();

   List<Integer> selectRoleListByUserId(Long userId);

   SysRole selectRoleById(Long roleId);

   String checkRoleNameUnique(SysRole role);

   String checkRoleKeyUnique(SysRole role);

   void checkRoleAllowed(SysRole role);

   int countUserRoleByRoleId(Long roleId);

   int insertRole(SysRole role);

   int updateRole(SysRole role);

   int updateRoleStatus(SysRole role);

   int authDataScope(SysRole role);

   int deleteRoleById(Long roleId);

   int deleteRoleByIds(Long[] roleIds);
}
