package com.wechat.project.webservice.imp;

import com.wechat.project.basis.service.IOperationService;
import com.wechat.project.webservice.IWebServiceByApp;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@WebService(
   serviceName = "IWebServiceByApp",
   targetNamespace = "http://webservice.project.wechat.com/hipAction",
   endpointInterface = "com.wechat.project.webservice.IWebServiceByApp"
)
public class WebServiceByAppImp implements IWebServiceByApp {
   private static final Logger log = LoggerFactory.getLogger(WebServiceByAppImp.class);
   @Autowired
   private IOperationService iOperationService;

   @Override
   public String hipAction(String request) throws Exception {
      System.out.println("初始化参数：" + request);
      String str = this.iOperationService.mainService(request);
      System.out.println("接口调用结果str:" + str);
      return str;
   }
}
