package com.wechat.common.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class QRCodeUtils {
   public static byte[] getQRCodeImageStream(String text, int width, int height) throws WriterException, IOException {
      QRCodeWriter qrCodeWriter = new QRCodeWriter();
      BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
      ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
      MatrixToImageWriter.writeToStream(bitMatrix, "PNG", pngOutputStream);
      return pngOutputStream.toByteArray();
   }

   public static String getQRCodeImageBase64(String text, int width, int height) throws WriterException, IOException {
      return Base64.encodeBase64String(getQRCodeImageStream(text, width, height));
   }

   public static String Generate2(String text, int width, int height) throws IOException, WriterException {
      BitMatrix byteMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.CODE_93, width, height);
      ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
      MatrixToImageWriter.writeToStream(byteMatrix, "PNG", pngOutputStream);
      byte[] pngData = pngOutputStream.toByteArray();
      return Base64.encodeBase64String(pngData);
   }
}
