package com.wechat.common.utils;

import java.io.UnsupportedEncodingException;
import java.security.Security;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM3Utills {
   private static final String ENCODING = "UTF-8";

   public static String encrypt(String paramStr) {
      String resultHexString = "";

      try {
         byte[] srcData = paramStr.getBytes("UTF-8");
         byte[] resultHash = hash(srcData);
         resultHexString = ByteUtils.toHexString(resultHash);
      } catch (UnsupportedEncodingException var4) {
         var4.printStackTrace();
      }

      return resultHexString;
   }

   public static byte[] hash(byte[] srcData) {
      SM3Digest digest = new SM3Digest();
      digest.update(srcData, 0, srcData.length);
      byte[] hash = new byte[digest.getDigestSize()];
      digest.doFinal(hash, 0);
      return hash;
   }

   public static void main(String[] args) {
      String json = "{\"name\":\"Marydon\",\"website\":\"http://www.cnblogs.com/Marydon20170307\"}";
      String hex = encrypt(json);
      System.out.println(hex);
   }

   static {
      Security.addProvider(new BouncyCastleProvider());
   }
}
