package com.wechat.common.utils.http;

import com.alibaba.fastjson.JSONObject;
import com.wechat.common.utils.DateUtils;
import com.wechat.common.utils.xml.PropertiesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
   private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
   private static String pushUrl = PropertiesUtil.getInstance().get("pushUrl");

   public static String sendGet(String url, String param) {
      StringBuilder result = new StringBuilder();
      BufferedReader in = null;

      try {
         String urlNameString = url + "?" + param;
         log.info("sendGet - {}", urlNameString);
         URL realUrl = new URL(urlNameString);
         URLConnection connection = realUrl.openConnection();
         connection.setRequestProperty("accept", "*/*");
         connection.setRequestProperty("connection", "Keep-Alive");
         connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
         connection.connect();
         in = new BufferedReader(new InputStreamReader(connection.getInputStream()));

         String line;
         while ((line = in.readLine()) != null) {
            result.append(line);
         }

         log.info("recv - {}", result);
      } catch (ConnectException var22) {
         log.error("调用HttpUtils.sendGet ConnectException, url=" + url + ",param=" + param, var22);
      } catch (SocketTimeoutException var23) {
         log.error("调用HttpUtils.sendGet SocketTimeoutException, url=" + url + ",param=" + param, var23);
      } catch (IOException var24) {
         log.error("调用HttpUtils.sendGet IOException, url=" + url + ",param=" + param, var24);
      } catch (Exception var25) {
         log.error("调用HttpsUtil.sendGet Exception, url=" + url + ",param=" + param, var25);
      } finally {
         try {
            if (in != null) {
               in.close();
            }
         } catch (Exception var21) {
            log.error("调用in.close Exception, url=" + url + ",param=" + param, var21);
         }
      }

      return result.toString();
   }

   public static String sendPost(String url, String param) {
      PrintWriter out = null;
      BufferedReader in = null;
      StringBuilder result = new StringBuilder();

      try {
         String urlNameString = url + "?" + param;
         log.info("sendPost - {}", urlNameString);
         URL realUrl = new URL(urlNameString);
         URLConnection conn = realUrl.openConnection();
         conn.setRequestProperty("accept", "*/*");
         conn.setRequestProperty("connection", "Keep-Alive");
         conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
         conn.setRequestProperty("Accept-Charset", "utf-8");
         conn.setRequestProperty("contentType", "utf-8");
         conn.setDoOutput(true);
         conn.setDoInput(true);
         out = new PrintWriter(conn.getOutputStream());
         out.print(param);
         out.flush();
         in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));

         String line;
         while ((line = in.readLine()) != null) {
            result.append(line);
         }

         log.info("recv - {}", result);
      } catch (ConnectException var23) {
         log.error("调用HttpUtils.sendPost ConnectException, url=" + url + ",param=" + param, var23);
      } catch (SocketTimeoutException var24) {
         log.error("调用HttpUtils.sendPost SocketTimeoutException, url=" + url + ",param=" + param, var24);
      } catch (IOException var25) {
         log.error("调用HttpUtils.sendPost IOException, url=" + url + ",param=" + param, var25);
      } catch (Exception var26) {
         log.error("调用HttpsUtil.sendPost Exception, url=" + url + ",param=" + param, var26);
      } finally {
         try {
            if (out != null) {
               out.close();
            }

            if (in != null) {
               in.close();
            }
         } catch (IOException var22) {
            log.error("调用in.close Exception, url=" + url + ",param=" + param, var22);
         }
      }

      return result.toString();
   }

   public static String sendSSLPost(String url, String param) {
      StringBuilder result = new StringBuilder();
      String urlNameString = url + "?" + param;

      try {
         log.info("sendSSLPost - {}", urlNameString);
         SSLContext sc = SSLContext.getInstance("SSL");
         sc.init(null, new TrustManager[]{new HttpUtils.TrustAnyTrustManager()}, new SecureRandom());
         URL console = new URL(urlNameString);
         HttpsURLConnection conn = (HttpsURLConnection)console.openConnection();
         conn.setRequestProperty("accept", "*/*");
         conn.setRequestProperty("connection", "Keep-Alive");
         conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
         conn.setRequestProperty("Accept-Charset", "utf-8");
         conn.setRequestProperty("contentType", "utf-8");
         conn.setDoOutput(true);
         conn.setDoInput(true);
         conn.setSSLSocketFactory(sc.getSocketFactory());
         conn.setHostnameVerifier(new HttpUtils.TrustAnyHostnameVerifier());
         conn.connect();
         InputStream is = conn.getInputStream();
         BufferedReader br = new BufferedReader(new InputStreamReader(is));
         String ret = "";

         while ((ret = br.readLine()) != null) {
            if (ret != null && !ret.trim().equals("")) {
               result.append(new String(ret.getBytes("ISO-8859-1"), "utf-8"));
            }
         }

         log.info("recv - {}", result);
         conn.disconnect();
         br.close();
      } catch (ConnectException var10) {
         log.error("调用HttpUtils.sendSSLPost ConnectException, url=" + url + ",param=" + param, var10);
      } catch (SocketTimeoutException var11) {
         log.error("调用HttpUtils.sendSSLPost SocketTimeoutException, url=" + url + ",param=" + param, var11);
      } catch (IOException var12) {
         log.error("调用HttpUtils.sendSSLPost IOException, url=" + url + ",param=" + param, var12);
      } catch (Exception var13) {
         log.error("调用HttpsUtil.sendSSLPost Exception, url=" + url + ",param=" + param, var13);
      }

      return result.toString();
   }

   public static String sendPostByJson(String url, String json) {
      PrintWriter out = null;
      BufferedReader in = null;
      String result = "";

      try {
         URL realUrl = new URL(url);
         URLConnection conn = realUrl.openConnection();
         conn.setRequestProperty("accept", "*/*");
         conn.setRequestProperty("connection", "Keep-Alive");
         conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
         conn.setRequestProperty("content-type", "application/json");
         conn.setDoOutput(true);
         conn.setDoInput(true);
         conn.setConnectTimeout(5000);
         conn.setReadTimeout(30000);
         out = new PrintWriter(conn.getOutputStream());
         out.print(json);
         out.flush();
         in = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8")));

         String line;
         while ((line = in.readLine()) != null) {
            result = result + line;
         }
      } catch (Exception var16) {
         System.out.println("发送 POST 请求出现异常！" + var16 + " url=" + url);
         var16.printStackTrace();
      } finally {
         try {
            if (out != null) {
               out.close();
            }

            if (in != null) {
               in.close();
            }
         } catch (IOException var15) {
            var15.printStackTrace();
         }
      }

      return result;
   }

   public static JSONObject getRequestParamToJson(HttpServletRequest request) {
      JSONObject json = new JSONObject();
      Enumeration<String> param = request.getParameterNames();

      while (param.hasMoreElements()) {
         String pName = param.nextElement();
         json.put(pName, request.getParameter(pName));
      }

      return json;
   }

   public static void main(String[] args) {
      JSONObject json = new JSONObject();
      JSONObject json1 = new JSONObject();
      JSONObject json2 = new JSONObject();
      json.put("openid", "o3bP5054QValwZmjGGZhxds1ljFs");
      json.put("realName", "郭十四");
      json.put("type", "zyyj");
      json.put("data", DateUtils.getTime());
      json.put("outTradeNo", "66202002181806418617");
      json.put("hosCardNo", "2000011");
      json.put("totalAmount", "0.02");
      String Str = json.toString();
      json1.put("openid", "o3bP5054QValwZmjGGZhxds1ljFs");
      json1.put("type", "yygh");
      json1.put("realName", "郭十四");
      json1.put("deptName", "口腔科");
      json1.put("doctorName", "张德明");
      json1.put("data", "2020-02-28 7:30 11:30");
      String Str2 = json1.toString();
      json2.put("openid", "o3bP50yI8vHyx3PKuDTckwLaSO80");
      json2.put("type", "zyyjsb");
      json2.put("realName", "郭十四");
      json2.put("deptName", "口腔科");
      json2.put("totalAmount", "0.02");
      json2.put("syu", "500.00 元");
      String Str3 = json2.toString();
      System.out.println(pushUrl);
      sendPostByJson(pushUrl, Str3);
      System.out.println("===启动成功===");
   }

   private static class TrustAnyHostnameVerifier implements HostnameVerifier {
      private TrustAnyHostnameVerifier() {
      }

      @Override
      public boolean verify(String hostname, SSLSession session) {
         return true;
      }
   }

   private static class TrustAnyTrustManager implements X509TrustManager {
      private TrustAnyTrustManager() {
      }

      @Override
      public void checkClientTrusted(X509Certificate[] chain, String authType) {
      }

      @Override
      public void checkServerTrusted(X509Certificate[] chain, String authType) {
      }

      @Override
      public X509Certificate[] getAcceptedIssuers() {
         return new X509Certificate[0];
      }
   }
}
