package com.wechat.framework.aspectj;

import com.wechat.common.utils.StringUtils;
import com.wechat.framework.aspectj.lang.annotation.DataSource;
import com.wechat.framework.datasource.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(1)
@Component
public class DataSourceAspect {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());

   @Pointcut("@annotation(com.wechat.framework.aspectj.lang.annotation.DataSource)|| @within(com.wechat.framework.aspectj.lang.annotation.DataSource)")
   public void dsPointCut() {
   }

   @Around("dsPointCut()")
   public Object around(ProceedingJoinPoint point) throws Throwable {
      DataSource dataSource = this.getDataSource(point);
      if (StringUtils.isNotNull(dataSource)) {
         DynamicDataSourceContextHolder.setDataSourceType(dataSource.value().name());
      }

      Object var3;
      try {
         var3 = point.proceed();
      } finally {
         DynamicDataSourceContextHolder.clearDataSourceType();
      }

      return var3;
   }

   public DataSource getDataSource(ProceedingJoinPoint point) {
      MethodSignature signature = (MethodSignature)point.getSignature();
      Class<? extends Object> targetClass = (Class<? extends Object>)point.getTarget().getClass();
      DataSource targetDataSource = targetClass.getAnnotation(DataSource.class);
      if (StringUtils.isNotNull(targetDataSource)) {
         return targetDataSource;
      } else {
         Method method = signature.getMethod();
         return method.getAnnotation(DataSource.class);
      }
   }
}
