package com.wechat.framework.config;

import com.wechat.framework.security.filter.JwtAuthenticationTokenFilter;
import com.wechat.framework.security.handle.AuthenticationEntryPointImpl;
import com.wechat.framework.security.handle.LogoutSuccessHandlerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer.AuthorizedUrl;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(
        prePostEnabled = true,
        securedEnabled = true
)
public class SecurityConfig extends WebSecurityConfigurerAdapter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AuthenticationEntryPointImpl unauthorizedHandler;
    @Autowired
    private LogoutSuccessHandlerImpl logoutSuccessHandler;
    @Autowired
    private JwtAuthenticationTokenFilter authenticationTokenFilter;
    @Autowired
    private SmsCodeAuthenticationSecurityConfig smsCodeAuthenticationSecurityConfig;

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        ((HttpSecurity) ((HttpSecurity) ((FormLoginConfigurer) ((FormLoginConfigurer) ((HttpSecurity) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((AuthorizedUrl) ((HttpSecurity) ((HttpSecurity) httpSecurity.csrf()
                .disable())
                .exceptionHandling()
                .authenticationEntryPoint(this.unauthorizedHandler)
                .and())
                .authorizeRequests()
                .antMatchers(new String[]{"/login", "/captchaImage"}))
                .anonymous()
                .antMatchers(
                        HttpMethod.GET, new String[]{"/*.html", "/**/*.html", "/**/*.css", "/**/*.js"}
                ))
                .permitAll()
                .antMatchers(new String[]{"/websocket/**"}))
                .permitAll()
                .antMatchers(new String[]{"/mapi/**"}))
                .permitAll()
                .antMatchers(new String[]{"/system/dict/data/dictType/**"}))
                .permitAll()
                .antMatchers(new String[]{"/standard/paramInfo/title/**"}))
                .permitAll()
                .antMatchers(new String[]{"/webservice/**","/open/**"}))
                .permitAll()
                .antMatchers(new String[]{"/xinhua/**"}))
                .permitAll()
                .antMatchers(new String[]{"/profile/**"}))
                .permitAll()
                .antMatchers(new String[]{"/common/download**"}))
                .anonymous()
                .antMatchers(new String[]{"/swagger-ui.html"}))
                .permitAll()
                .antMatchers(new String[]{"/swagger-resources/**"}))
                .permitAll()
                .antMatchers(new String[]{"/webjars/**"}))
                .anonymous()
                .antMatchers(new String[]{"/*/api-docs"}))
                .permitAll()
                .antMatchers(new String[]{"/druid/**"}))
                .anonymous()
                .anyRequest())
                .authenticated()
                .and())
                .formLogin()
                .loginProcessingUrl("/api/user/login"))
                .permitAll())
                .and())
                .authorizeRequests()
                .mvcMatchers(new String[]{"/mapi/user/**"})
                .anonymous()
                .and())
                .headers()
                .frameOptions()
                .disable();
        ((HttpSecurity) ((FormLoginConfigurer) ((FormLoginConfigurer) ((HttpSecurity) ((AuthorizedUrl) ((AuthorizedUrl) ((HttpSecurity) ((SmsCodeAuthenticationSecurityConfig) httpSecurity.apply(
                this.smsCodeAuthenticationSecurityConfig
        ))
                .and())
                .authorizeRequests()
                .antMatchers(new String[]{"/mapi/user/**"}))
                .permitAll()
                .anyRequest())
                .authenticated()
                .and())
                .formLogin()
                .loginPage("/login")
                .defaultSuccessUrl("/"))
                .permitAll())
                .and())
                .logout()
                .permitAll();
        httpSecurity.logout().logoutUrl("/logout").logoutSuccessHandler(this.logoutSuccessHandler);
        httpSecurity.addFilterBefore(this.authenticationTokenFilter, UsernamePasswordAuthenticationFilter.class);
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.bCryptPasswordEncoder());
    }
}
