package com.wechat.framework.config;

import com.wechat.framework.redis.RedisCache;
import com.wechat.framework.security.filter.SmsCodeAuthenticationFilter;
import com.wechat.framework.security.handle.CustomAuthenticationFailureHandler;
import com.wechat.framework.security.handle.CustomAuthenticationSuccessHandler;
import com.wechat.framework.security.handle.SmsCodeAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.stereotype.Component;

@Component
public class SmsCodeAuthenticationSecurityConfig extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
   @Autowired
   private UserDetailsService userDetailsService;
   @Autowired
   private CustomAuthenticationSuccessHandler customAuthenticationSuccessHandler;
   @Autowired
   private CustomAuthenticationFailureHandler customAuthenticationFailureHandler;
   @Autowired
   private RedisCache redisCache;

   public void configure(HttpSecurity http) throws Exception {
      SmsCodeAuthenticationFilter smsCodeAuthenticationFilter = new SmsCodeAuthenticationFilter();
      smsCodeAuthenticationFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
      smsCodeAuthenticationFilter.setAuthenticationSuccessHandler(this.customAuthenticationSuccessHandler);
      smsCodeAuthenticationFilter.setAuthenticationFailureHandler(this.customAuthenticationFailureHandler);
      SmsCodeAuthenticationProvider smsCodeAuthenticationProvider = new SmsCodeAuthenticationProvider(this.redisCache);
      smsCodeAuthenticationProvider.setUserDetailsService(this.userDetailsService);
      http.authenticationProvider(smsCodeAuthenticationProvider).addFilterAfter(smsCodeAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
   }
}
