package com.wechat.framework.config;

import com.wechat.project.webservice.IWebServiceByApp;
import javax.xml.ws.Endpoint;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebServiceConfig {
   @Autowired
   private IWebServiceByApp webServiceByAppImp;

   @Bean(
      name = {"cxfServlet"}
   )
   public ServletRegistrationBean cxfServlet() {
      return new ServletRegistrationBean(new CXFServlet(), new String[]{"/webservice/*"});
   }

   @Bean(
      name = {"cxf"}
   )
   public SpringBus springBus() {
      return new SpringBus();
   }

   @Bean(
      name = {"IWebServiceByAppEndpoint"}
   )
   public Endpoint sweptAppEndpoint2() {
      EndpointImpl endpoint = new EndpointImpl(this.springBus(), this.webServiceByAppImp);
      endpoint.publish("/appservice");
      return endpoint;
   }
}
