package com.wechat.framework.security.handle;

import com.wechat.framework.redis.RedisCache;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SmsCodeAuthenticationProvider implements AuthenticationProvider {
   private UserDetailsService userDetailsService;
   private RedisCache redisCache;

   public SmsCodeAuthenticationProvider(RedisCache _redisCache) {
      this.redisCache = _redisCache;
   }

   public Authentication authenticate(Authentication authentication) throws AuthenticationException {
      SmsCodeAuthenticationToken authenticationToken = (SmsCodeAuthenticationToken)authentication;
      String mobile = (String)authenticationToken.getPrincipal();
      this.checkSmsCode(mobile);
      UserDetails userDetails = this.userDetailsService.loadUserByUsername(mobile);
      SmsCodeAuthenticationToken authenticationResult = new SmsCodeAuthenticationToken(userDetails, userDetails.getAuthorities());
      authenticationResult.setDetails(authenticationToken.getDetails());
      return authenticationResult;
   }

   private void checkSmsCode(String mobile) {
      HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
      String inputCode = request.getParameter("code");
      String smsCode = this.redisCache.getCacheObject(mobile);
      if (smsCode == null) {
         throw new BadCredentialsException("验证码错误");
      } else {
         int code = Integer.parseInt(smsCode);
         if (code != Integer.parseInt(inputCode)) {
            throw new BadCredentialsException("验证码错误");
         }
      }
   }

   public boolean supports(Class<?> authentication) {
      return SmsCodeAuthenticationToken.class.isAssignableFrom(authentication);
   }

   public UserDetailsService getUserDetailsService() {
      return this.userDetailsService;
   }

   public void setUserDetailsService(UserDetailsService userDetailsService) {
      this.userDetailsService = userDetailsService;
   }
}
