package com.wechat.framework.security.handle;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class SmsCodeAuthenticationToken extends AbstractAuthenticationToken {
   private static final long serialVersionUID = 510L;
   private final Object principal;

   public SmsCodeAuthenticationToken(Object principal) {
      super(null);
      this.principal = principal;
      this.setAuthenticated(false);
   }

   public SmsCodeAuthenticationToken(Object principal, Collection<? extends GrantedAuthority> authorities) {
      super(authorities);
      this.principal = principal;
      super.setAuthenticated(true);
   }

   public Object getCredentials() {
      return null;
   }

   public Object getPrincipal() {
      return this.principal;
   }

   public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
      if (isAuthenticated) {
         throw new IllegalArgumentException("Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
      } else {
         super.setAuthenticated(false);
      }
   }

   public void eraseCredentials() {
      super.eraseCredentials();
   }
}
