package com.wechat.framework.security.service;

import com.wechat.common.exception.CustomException;
import com.wechat.common.exception.user.CaptchaExpireException;
import com.wechat.common.exception.user.UserPasswordNotMatchException;
import com.wechat.common.utils.MessageUtils;
import com.wechat.framework.manager.AsyncManager;
import com.wechat.framework.manager.factory.AsyncFactory;
import com.wechat.framework.redis.RedisCache;
import com.wechat.framework.security.LoginUser;
import com.wechat.framework.security.handle.SmsCodeAuthenticationToken;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class SysLoginService {
   @Autowired
   private TokenService tokenService;
   @Resource
   private AuthenticationManager authenticationManager;
   @Autowired
   private RedisCache redisCache;

   public String login(String username, String password, String code, String uuid) {
      if (!password.isEmpty() && !uuid.isEmpty()) {
         /*String verifyKey = "captcha_codes:" + uuid;
         String captcha = this.redisCache.getCacheObject(verifyKey);
         this.redisCache.deleteObject(verifyKey);
         if (captcha == null) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message("user.jcaptcha.error")));
            throw new CaptchaExpireException();
         }*/
      } else {
         this.redisCache.deleteObject(username);
      }

      Authentication authentication = null;

      try {
         if (!password.isEmpty() && !uuid.isEmpty()) {
            authentication = this.authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(username, password));
         } else {
            authentication = this.authenticationManager.authenticate(new SmsCodeAuthenticationToken(username));
         }
      } catch (Exception var7) {
         if (var7 instanceof BadCredentialsException) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", MessageUtils.message("user.password.not.match")));
            throw new UserPasswordNotMatchException();
         }

         AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Error", var7.getMessage()));
         throw new CustomException(var7.getMessage());
      }

      AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, "Success", MessageUtils.message("user.login.success")));
      LoginUser loginUser = (LoginUser)authentication.getPrincipal();
      return this.tokenService.createToken(loginUser);
   }
}
