package com.wechat.project.basis.controller;

import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.basis.domain.Dept;
import com.wechat.project.basis.service.IDeptService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/basis/deptDict"})
public class DeptController extends BaseController {
   @Autowired
   private IDeptService deptService;

   @PreAuthorize("@ss.hasPermi('basis:deptDict:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(Dept dept) {
      this.startPage();
      List<Dept> list = this.deptService.selectDeptList(dept);
      return this.getDataTable(list);
   }

   @PreAuthorize("@ss.hasPermi('basis:deptDict:export')")
   @Log(
      title = "科室字典",
      businessType = BusinessType.EXPORT
   )
   @GetMapping({"/export"})
   public AjaxResult export(Dept dept) {
      List<Dept> list = this.deptService.selectDeptList(dept);
      ExcelUtil<Dept> util = new ExcelUtil<>(Dept.class);
      return util.exportExcel(list, "deptDict");
   }

   @PreAuthorize("@ss.hasPermi('basis:deptDict:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable("id") Long id) {
      return AjaxResult.success(this.deptService.selectDeptById(id));
   }

   @PreAuthorize("@ss.hasPermi('basis:deptDict:add')")
   @Log(
      title = "科室字典",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@RequestBody Dept dept) {
      return this.toAjax(this.deptService.insertDept(dept));
   }

   @PreAuthorize("@ss.hasPermi('basis:deptDict:edit')")
   @Log(
      title = "科室字典",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@RequestBody Dept dept) {
      return this.toAjax(this.deptService.updateDept(dept));
   }

   @PreAuthorize("@ss.hasPermi('basis:deptDict:remove')")
   @Log(
      title = "科室字典",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.deptService.deleteDeptByIds(ids));
   }
}
