package com.wechat.project.basis.controller;

import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.basis.domain.Emp;
import com.wechat.project.basis.service.IEmpService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/basis/empDict"})
public class EmpController extends BaseController {
   @Autowired
   private IEmpService empService;

   @PreAuthorize("@ss.hasPermi('basis:empDict:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(Emp emp) {
      this.startPage();
      List<Emp> list = this.empService.selectEmpList(emp);
      return this.getDataTable(list);
   }

   @PreAuthorize("@ss.hasPermi('basis:empDict:export')")
   @Log(
      title = "员工",
      businessType = BusinessType.EXPORT
   )
   @GetMapping({"/export"})
   public AjaxResult export(Emp emp) {
      List<Emp> list = this.empService.selectEmpList(emp);
      ExcelUtil<Emp> util = new ExcelUtil<>(Emp.class);
      return util.exportExcel(list, "empDict");
   }

   @PreAuthorize("@ss.hasPermi('basis:empDict:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable("id") Long id) {
      return AjaxResult.success(this.empService.selectEmpById(id));
   }

   @PreAuthorize("@ss.hasPermi('basis:empDict:add')")
   @Log(
      title = "员工",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@RequestBody Emp emp) {
      return this.toAjax(this.empService.insertEmp(emp));
   }

   @PreAuthorize("@ss.hasPermi('basis:empDict:edit')")
   @Log(
      title = "员工",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@RequestBody Emp emp) {
      return this.toAjax(this.empService.updateEmp(emp));
   }

   @PreAuthorize("@ss.hasPermi('basis:empDict:remove')")
   @Log(
      title = "员工",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.empService.deleteEmpByIds(ids));
   }
}
