package com.wechat.project.common;

import com.wechat.common.utils.StringUtils;
import com.wechat.common.utils.file.FileUploadUtils;
import com.wechat.common.utils.file.FileUtils;
import com.wechat.framework.config.ServerConfig;
import com.wechat.framework.config.WechatConfig;
import com.wechat.framework.web.domain.AjaxResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping({"/"})
public class CommonController {
   private static final Logger log = LoggerFactory.getLogger(CommonController.class);
   @Autowired
   private ServerConfig serverConfig;

   @GetMapping({"download"})
   public void fileDownload(String fileName, Boolean delete, HttpServletResponse response, HttpServletRequest request) {
      try {
         if (!FileUtils.isValidFilename(fileName)) {
            throw new Exception(StringUtils.format("文件名称({})非法，不允许下载。", fileName));
         }

         String realFileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("_") + 1);
         String filePath = WechatConfig.getDownloadPath() + fileName;
         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=" + FileUtils.setFileDownloadHeader(request, realFileName));
         FileUtils.writeBytes(filePath, response.getOutputStream());
         if (delete) {
            FileUtils.deleteFile(filePath);
         }
      } catch (Exception var7) {
         log.error("下载文件失败", var7);
      }
   }

   @PostMapping({"upload"})
   public AjaxResult uploadFile(MultipartFile file) throws Exception {
      System.out.println("9999999999999");

      try {
         String filePath = WechatConfig.getUploadPath();
         String fileName = FileUploadUtils.upload(filePath, file);
         String url = this.serverConfig.getUrl() + fileName;
         AjaxResult ajax = AjaxResult.success();
         ajax.put("fileName", fileName);
         ajax.put("url", url);
         return ajax;
      } catch (Exception var6) {
         return AjaxResult.error(var6.getMessage());
      }
   }
}
