package com.wechat.project.menutree.Utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannel.MapMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
   protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
   protected static MessageDigest messagedigest = null;
   private static final char[] HEX_DIGITS;

   public static String getMD5String(String s) {
      return getMD5String(s.getBytes());
   }

   public static boolean checkPassword(String password, String md5PwdStr) {
      String s = getMD5String(password);
      return s.equals(md5PwdStr);
   }

   public static String getFileMD5String(File file) throws IOException {
      InputStream fis = new FileInputStream(file);
      byte[] buffer = new byte[1024];
      int numRead = 0;

      while ((numRead = fis.read(buffer)) > 0) {
         messagedigest.update(buffer, 0, numRead);
      }

      fis.close();
      return bufferToHex(messagedigest.digest());
   }

   public static String getFileMD5String_old(File file) throws IOException {
      FileInputStream in = new FileInputStream(file);
      FileChannel ch = in.getChannel();
      MappedByteBuffer byteBuffer = ch.map(MapMode.READ_ONLY, 0L, file.length());
      messagedigest.update(byteBuffer);
      return bufferToHex(messagedigest.digest());
   }

   public static String getMD5String(byte[] bytes) {
      messagedigest.update(bytes);
      return bufferToHex(messagedigest.digest());
   }

   private static String bufferToHex(byte[] bytes) {
      return bufferToHex(bytes, 0, bytes.length);
   }

   private static String bufferToHex(byte[] bytes, int m, int n) {
      StringBuffer stringbuffer = new StringBuffer(2 * n);
      int k = m + n;

      for (int l = m; l < k; l++) {
         appendHexPair(bytes[l], stringbuffer);
      }

      return stringbuffer.toString();
   }

   private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
      char c0 = hexDigits[(bt & 240) >> 4];
      char c1 = hexDigits[bt & 15];
      stringbuffer.append(c0);
      stringbuffer.append(c1);
   }

   private static String toHexString(byte[] b) {
      StringBuilder sb = new StringBuilder(b.length * 2);

      for (int i = 0; i < b.length; i++) {
         sb.append(HEX_DIGITS[(b[i] & 240) >>> 4]);
         sb.append(HEX_DIGITS[b[i] & 15]);
      }

      return sb.toString();
   }

   public static String Bit32(String SourceString) {
      messagedigest.update(SourceString.getBytes());
      byte[] messageDigest = messagedigest.digest();
      return toHexString(messageDigest);
   }

   public static String Bit16(String SourceString) {
      return Bit32(SourceString).substring(8, 24);
   }

   static {
      try {
         messagedigest = MessageDigest.getInstance("MD5");
      } catch (NoSuchAlgorithmException var1) {
         System.err.println(MD5Util.class.getName() + "初始化失败，MessageDigest不支持MD5Util。");
         var1.printStackTrace();
      }

      HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
   }
}
