package com.wechat.project.menutree.controller;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.menutree.Utils.MD5Util;
import com.wechat.project.menutree.domain.User;
import com.wechat.project.menutree.service.IUserService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping({"/mapi/info"})
public class UserController extends BaseController {
   @Autowired
   private IUserService userService;

   @CrossOrigin
   @GetMapping({"/userLogin"})
   public User login(@RequestParam("username") String username, @RequestParam("password") String password, Model model) {
      password = MD5Util.getMD5String(password);
      User user = this.userService.selectLogin(username, password);
      if (null != user) {
         return user;
      } else {
         model.addAttribute("msg", "登录失败");
         return null;
      }
   }

   @PreAuthorize("@ss.hasPermi('demo:user:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(User user) {
      this.startPage();
      List<User> list = this.userService.selectUserList(user);
      return this.getDataTable(list);
   }

   @Log(
      title = "用户",
      businessType = BusinessType.EXPORT
   )
   @PreAuthorize("@ss.hasPermi('demo:user:export')")
   @GetMapping({"/export"})
   public AjaxResult export(User user) {
      List<User> list = this.userService.selectUserList(user);
      ExcelUtil<User> util = new ExcelUtil<>(User.class);
      return util.exportExcel(list, "用户");
   }

   @PreAuthorize("@ss.hasPermi('demo:user:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable Long id) {
      return AjaxResult.success(this.userService.selectUserById(id));
   }

   @PreAuthorize("@ss.hasPermi('demo:user:add')")
   @Log(
      title = "用户",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@Validated @RequestBody User user) {
      user.setCreateBy(SecurityUtils.getUsername());
      return this.toAjax(this.userService.insertUser(user));
   }

   @PreAuthorize("@ss.hasPermi('demo:user:edit')")
   @Log(
      title = "用户管理",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@Validated @RequestBody User user) {
      user.setPassword(MD5Util.getMD5String(user.getPassword()));
      user.setUpdateBy(SecurityUtils.getUsername());
      return this.toAjax(this.userService.updateUser(user));
   }

   @PreAuthorize("@ss.hasPermi('demo:user:remove')")
   @Log(
      title = "用户管理",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.userService.deleteUserByIds(ids));
   }
}
