package com.wechat.project.mobile.service.impl;

import com.wechat.project.mobile.domain.UserWechat;
import com.wechat.project.mobile.mapper.UserWechatMapper;
import com.wechat.project.mobile.service.IUserWechatService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserWechatServiceImpl implements IUserWechatService {
   @Autowired
   private UserWechatMapper userWechatMapper;

   @Override
   public List<UserWechat> selectUserWechatList(UserWechat userWechat) {
      return this.userWechatMapper.selectUserWechatList(userWechat);
   }

   @Override
   public List<UserWechat> selectUserWechatAll() {
      return this.userWechatMapper.selectUserWechatAll();
   }

   @Override
   public UserWechat selectUserWechatById(Integer id) {
      return this.userWechatMapper.selectUserWechatById(id);
   }

   @Override
   public UserWechat selectUserWechatByOpenId(String openId) {
      return this.userWechatMapper.selectUserWechatByOpenId(openId);
   }

   @Override
   public int deleteUserWechatById(Integer id) {
      return this.userWechatMapper.deleteUserWechatById(id);
   }

   @Override
   public int deleteUserWechatByIds(Integer[] ids) {
      return this.userWechatMapper.deleteUserWechatByIds(ids);
   }

   @Override
   public int insertUserWechat(UserWechat userWechat) {
      return this.userWechatMapper.insertUserWechat(userWechat);
   }

   @Override
   public int updateUserWechat(UserWechat userWechat) {
      return this.userWechatMapper.updateUserWechat(userWechat);
   }
}
