package com.wechat.project.monitor.service.impl;

import com.wechat.framework.aspectj.lang.annotation.DataSource;
import com.wechat.framework.aspectj.lang.enums.DataSourceType;
import com.wechat.project.monitor.domain.SysOperLog;
import com.wechat.project.monitor.mapper.SysOperLogMapper;
import com.wechat.project.monitor.service.ISysOperLogService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysOperLogServiceImpl implements ISysOperLogService {
   @Autowired
   private SysOperLogMapper operLogMapper;

   @DataSource(DataSourceType.MASTER)
   @Override
   public void insertOperlog(SysOperLog operLog) {
      this.operLogMapper.insertOperlog(operLog);
   }

   @DataSource(DataSourceType.MASTER)
   @Override
   public List<SysOperLog> selectOperLogList(SysOperLog operLog) {
      return this.operLogMapper.selectOperLogList(operLog);
   }

   @DataSource(DataSourceType.MASTER)
   @Override
   public int deleteOperLogByIds(Long[] operIds) {
      return this.operLogMapper.deleteOperLogByIds(operIds);
   }

   @DataSource(DataSourceType.MASTER)
   @Override
   public SysOperLog selectOperLogById(Long operId) {
      return this.operLogMapper.selectOperLogById(operId);
   }

   @DataSource(DataSourceType.MASTER)
   @Override
   public void cleanOperLog() {
      this.operLogMapper.cleanOperLog();
   }
}
